/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.remote.transport.impl;

import com.jxdinfo.hussar.support.job.core.JobSerializable;
import com.jxdinfo.hussar.support.job.core.enums.Protocol;
import com.jxdinfo.hussar.support.job.core.response.AskResponse;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.dispatch.remote.transport.Transporter;
import com.jxdinfo.hussar.support.job.dispatch.remote.transport.starter.VertXStarter;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HttpTransporter
implements Transporter {
    private static final Logger log = LoggerFactory.getLogger(HttpTransporter.class);
    private final WebClient webClient;

    public HttpTransporter() {
        WebClientOptions options = new WebClientOptions().setKeepAlive(false).setConnectTimeout(5000);
        this.webClient = WebClient.create((Vertx)Vertx.vertx(), (WebClientOptions)options);
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.HTTP;
    }

    @Override
    public String getAddress() {
        return VertXStarter.getAddress();
    }

    @Override
    public void tell(String address, JobSerializable object) {
        this.postRequest(address, object);
    }

    @Override
    public AskResponse ask(String address, JobSerializable object) throws Exception {
        CompletableFuture future = this.postRequest(address, object).toCompletionStage().toCompletableFuture();
        HttpResponse httpResponse = (HttpResponse)future.get(5000L, TimeUnit.MILLISECONDS);
        return (AskResponse)httpResponse.bodyAsJson(AskResponse.class);
    }

    private Future<HttpResponse<Buffer>> postRequest(String address, JobSerializable object) {
        Pair ipAndPort = NetUtils.splitAddress2IpAndPort((String)address);
        String ip = (String)ipAndPort.getLeft();
        int port = (Integer)ipAndPort.getRight();
        return this.webClient.post(port, ip, object.path()).sendJson((Object)object).onSuccess(res -> log.info("[HttpTransporter] send request to {}{} successfully: {}, response: {}", new Object[]{address, object.path(), object, res})).onFailure(t -> log.warn("[HttpTransporter] send request to {}{} failed: {}", new Object[]{address, object.path(), object, t}));
    }
}

