/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.remote.server.redirector;

import akka.actor.ActorSelection;
import akka.pattern.Patterns;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.jxdinfo.hussar.platform.core.BooleanUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.job.core.exception.JobRuntimeException;
import com.jxdinfo.hussar.support.job.core.response.AskResponse;
import com.jxdinfo.hussar.support.job.core.support.JobAppInfoService;
import com.jxdinfo.hussar.support.job.core.support.entity.JobAppInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.remote.server.redirector.DesignateServer;
import com.jxdinfo.hussar.support.job.dispatch.remote.server.redirector.RemoteProcessReq;
import com.jxdinfo.hussar.support.job.dispatch.remote.transport.starter.AkkaStarter;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=0)
public class DesignateServerAspect {
    private static final Logger log = LoggerFactory.getLogger(DesignateServerAspect.class);
    @Resource
    private JobAppInfoService jobAppInfoService;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Around(value="@annotation(designateServer))")
    public Object execute(ProceedingJoinPoint point, DesignateServer designateServer) throws Throwable {
        Object[] args = point.getArgs();
        String methodName = point.getSignature().getName();
        String className = point.getSignature().getDeclaringTypeName();
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        String[] parameterNames = methodSignature.getParameterNames();
        String[] parameterTypes = (String[])Arrays.stream(methodSignature.getParameterTypes()).map(Class::getName).toArray(String[]::new);
        Long appId = null;
        for (int i = 0; i < parameterNames.length; ++i) {
            if (!StringUtils.equals((CharSequence)parameterNames[i], (CharSequence)designateServer.appIdParameterName())) continue;
            appId = Long.parseLong(String.valueOf(args[i]));
            break;
        }
        if (appId == null) {
            throw new JobRuntimeException("can't find appId in params for:" + signature);
        }
        JobAppInfoEntity appInfo = (JobAppInfoEntity)Optional.ofNullable(this.jobAppInfoService.getById(appId)).orElseThrow(() -> new JobRuntimeException("can't find app info"));
        String targetServer = appInfo.getCurrentServer();
        if (StringUtils.isEmpty((CharSequence)targetServer)) {
            return point.proceed();
        }
        Environment environment = SpringContextUtil.getApplicationContext().getEnvironment();
        Boolean isSingleModel = (Boolean)environment.getProperty("hussar.job.enable-single-model", Boolean.class);
        if (BooleanUtil.isTrue((Boolean)isSingleModel)) {
            return point.proceed();
        }
        if (Objects.equals(targetServer, AkkaStarter.getActorSystemAddress())) {
            return point.proceed();
        }
        log.info("[DesignateServerAspect] the method[{}] should execute in server[{}], so this request will be redirect to remote server!", (Object)signature.toShortString(), (Object)targetServer);
        RemoteProcessReq remoteProcessReq = new RemoteProcessReq().setClassName(className).setMethodName(methodName).setParameterTypes(parameterTypes).setArgs(args);
        CompletionStage askCS = Patterns.ask((ActorSelection)AkkaStarter.getFriendActor(targetServer), (Object)remoteProcessReq, (Duration)Duration.ofMillis(5000L));
        AskResponse askResponse = (AskResponse)askCS.toCompletableFuture().get();
        if (!askResponse.isSuccess()) {
            throw new JobRuntimeException("remote process failed: " + askResponse.getMessage());
        }
        Method method = methodSignature.getMethod();
        JavaType returnType = DesignateServerAspect.getMethodReturnJavaType(method);
        return OBJECT_MAPPER.readValue(askResponse.getData(), returnType);
    }

    private static JavaType getMethodReturnJavaType(Method method) {
        Type type = method.getGenericReturnType();
        return DesignateServerAspect.getJavaType(type);
    }

    private static JavaType getJavaType(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            Class rowClass = (Class)((ParameterizedType)type).getRawType();
            JavaType[] javaTypes = new JavaType[actualTypeArguments.length];
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                javaTypes[i] = DesignateServerAspect.getJavaType(actualTypeArguments[i]);
            }
            return TypeFactory.defaultInstance().constructParametricType(rowClass, javaTypes);
        }
        return TypeFactory.defaultInstance().constructParametricType((Class)type, new JavaType[0]);
    }
}

