/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.remote.transport.starter;

import com.google.common.base.Stopwatch;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.dispatch.remote.config.JobDispatchProperties;
import io.vertx.core.Vertx;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class VertXStarter {
    private static Logger log = LoggerFactory.getLogger(VertXStarter.class);
    public static Vertx vertx;
    private static String address;

    public static void init(Environment environment, JobDispatchProperties jobDispatchProperties) {
        String portFromJVM;
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("[HussarJob] HussarJob's vert.x system start to bootstrap...");
        Integer port = jobDispatchProperties.getHttpPort();
        if (HussarUtils.isEmpty((Object)port)) {
            Integer serverPort = HussarUtils.isEmpty((Object)environment.getProperty("server.port")) ? Integer.valueOf(10010) : (Integer)environment.getProperty("server.port", Integer.class);
            port = serverPort + 2444;
        }
        if (StringUtils.isNotEmpty((CharSequence)(portFromJVM = System.getProperty("hussar.job.dispatch.http-port")))) {
            port = Integer.parseInt(portFromJVM);
        }
        String localIP = NetUtils.getLocalHost();
        address = localIP + ":" + port;
        log.info("[HussarJob] vert.x server address: {}", (Object)address);
        vertx = Vertx.vertx();
        log.info("[HussarJob] HussarJob's vert.x system started successfully, using time {}.", (Object)stopwatch);
    }

    public static String getAddress() {
        return address;
    }
}

