/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.remote.transport.impl;

import akka.actor.ActorSelection;
import akka.pattern.Patterns;
import com.jxdinfo.hussar.support.job.core.JobSerializable;
import com.jxdinfo.hussar.support.job.core.enums.Protocol;
import com.jxdinfo.hussar.support.job.core.response.AskResponse;
import com.jxdinfo.hussar.support.job.dispatch.remote.transport.Transporter;
import com.jxdinfo.hussar.support.job.dispatch.remote.transport.starter.AkkaStarter;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Service;

@Service
public class AkkaTransporter
implements Transporter {
    @Override
    public Protocol getProtocol() {
        return Protocol.AKKA;
    }

    @Override
    public String getAddress() {
        return AkkaStarter.getActorSystemAddress();
    }

    @Override
    public void tell(String address, JobSerializable object) {
        ActorSelection taskTrackerActor = AkkaStarter.getWorkerActor(address);
        taskTrackerActor.tell((Object)object, null);
    }

    @Override
    public AskResponse ask(String address, JobSerializable object) throws Exception {
        ActorSelection taskTrackerActor = AkkaStarter.getWorkerActor(address);
        CompletionStage askCS = Patterns.ask((ActorSelection)taskTrackerActor, (Object)object, (Duration)Duration.ofMillis(5000L));
        return (AskResponse)askCS.toCompletableFuture().get(5000L, TimeUnit.MILLISECONDS);
    }
}

