/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.remote.server;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.base.Stopwatch;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.core.exception.JobRuntimeException;
import com.jxdinfo.hussar.support.job.core.properties.JobProperties;
import com.jxdinfo.hussar.support.job.core.utils.CommonUtils;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.dispatch.dao.entity.JobServerInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.dao.service.JobServerInfoService;
import com.jxdinfo.hussar.support.job.dispatch.extension.LockService;
import com.jxdinfo.hussar.support.job.dispatch.remote.config.JobDispatchProperties;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ServerInfoService {
    private static Logger log = LoggerFactory.getLogger(ServerInfoService.class);
    private final String ip;
    private final long serverId;
    private final JobServerInfoService jobServerInfoService;
    private String version = "UNKNOWN";
    private static final long MAX_SERVER_CLUSTER_SIZE = 10000L;
    private static final String SERVER_INIT_LOCK = "server_init_lock";
    private static final int SERVER_INIT_LOCK_MAX_TIME = 15000;

    public long getServerId() {
        return this.serverId;
    }

    public String getServerIp() {
        return this.ip;
    }

    public String getServerVersion() {
        return this.version;
    }

    public ServerInfoService(LockService lockService, JobServerInfoService jobServerInfoService, JobProperties jobProperties, JobDispatchProperties jobDispatchProperties) {
        String serverIp = NetUtils.getLocalHost();
        if (!jobProperties.isEnableSingleModel() && HussarUtils.isNotEmpty((Object)jobDispatchProperties.getAkkaIp())) {
            serverIp = jobDispatchProperties.getAkkaIp();
        }
        this.ip = serverIp;
        this.jobServerInfoService = jobServerInfoService;
        Stopwatch sw = Stopwatch.createStarted();
        while (!jobProperties.isEnableSingleModel() && !lockService.tryLock(SERVER_INIT_LOCK, 15000L)) {
            log.info("[ServerInfoService] waiting for lock: {}", (Object)SERVER_INIT_LOCK);
            CommonUtils.easySleep((long)100L);
        }
        try {
            JobServerInfoEntity server = (JobServerInfoEntity)jobServerInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(JobServerInfoEntity::getIp, (Object)this.ip));
            if (server == null) {
                JobServerInfoEntity newServerInfo = new JobServerInfoEntity(this.ip);
                jobServerInfoService.save((Object)newServerInfo);
                server = newServerInfo;
            } else {
                jobServerInfoService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).eq(JobServerInfoEntity::getIp, (Object)this.ip));
            }
            if (server.getId() > 0L && server.getId() < 10000L) {
                this.serverId = server.getId();
            } else {
                this.serverId = this.retryServerId();
                jobServerInfoService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(JobServerInfoEntity::getId, (Object)this.serverId)).eq(JobServerInfoEntity::getIp, (Object)this.ip));
            }
        }
        catch (Exception e) {
            log.error("[ServerInfoService] init server failed", (Throwable)e);
            throw e;
        }
        finally {
            lockService.unlock(SERVER_INIT_LOCK);
        }
        log.info("[ServerInfoService] ip:{}, id:{}, cost:{}", new Object[]{this.ip, this.serverId, sw});
    }

    @Scheduled(fixedRate=15000L, initialDelay=15000L)
    public void heartbeat() {
        this.jobServerInfoService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(HussarBaseEntity::getLastTime, (Object)LocalDateTime.now())).eq(JobServerInfoEntity::getIp, (Object)this.ip));
    }

    private long retryServerId() {
        List serverInfoList = this.jobServerInfoService.list();
        log.info("[ServerInfoService] current server record num in database: {}", (Object)serverInfoList.size());
        if ((long)serverInfoList.size() > 10000L) {
            Date oneDayAgo = DateUtils.addDays((Date)new Date(), (int)-1);
            int delNum = this.jobServerInfoService.getBaseMapper().delete((Wrapper)new LambdaQueryWrapper().lt(HussarBaseEntity::getLastTime, (Object)oneDayAgo));
            log.warn("[ServerInfoService] delete invalid {} server info record before {}", (Object)delNum, (Object)oneDayAgo);
            serverInfoList = this.jobServerInfoService.list();
        }
        if ((long)serverInfoList.size() > 10000L) {
            throw new JobRuntimeException(String.format("The hussar-job-dispatch-server cluster cannot accommodate %d machines, please rebuild another cluster", serverInfoList.size()));
        }
        Set uedServerIds = serverInfoList.stream().map(JobServerInfoEntity::getId).collect(Collectors.toSet());
        for (long i = 1L; i <= 10000L; ++i) {
            if (uedServerIds.contains(i)) continue;
            log.info("[ServerInfoService] ID[{}] is not used yet, try as new server id", (Object)i);
            return i;
        }
        throw new JobRuntimeException("impossible");
    }

    @Autowired(required=false)
    public void setBuildProperties(BuildProperties buildProperties) {
        if (buildProperties == null) {
            return;
        }
        String pomVersion = buildProperties.getVersion();
        if (StringUtils.isNotBlank((CharSequence)pomVersion)) {
            this.version = pomVersion;
        }
    }
}

