/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.alram;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jxdinfo.hussar.support.job.dispatch.dao.entity.JobUserInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.extension.Alarmable;
import com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.alram.module.Alarm;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlarmCenter {
    private static final Logger log = LoggerFactory.getLogger(AlarmCenter.class);
    private final ExecutorService POOL;
    private final List<Alarmable> BEANS = Lists.newLinkedList();

    @Autowired
    public AlarmCenter(List<Alarmable> alarmables) {
        int cores = Runtime.getRuntime().availableProcessors();
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("AlarmPool-%d").build();
        this.POOL = new ThreadPoolExecutor(cores, cores, 5L, TimeUnit.MINUTES, (BlockingQueue<Runnable>)Queues.newLinkedBlockingQueue(), factory);
        alarmables.forEach(bean -> {
            this.BEANS.add((Alarmable)bean);
            log.info("[AlarmCenter] bean(className={},obj={}) register to AlarmCenter successfully!", (Object)bean.getClass().getName(), bean);
        });
    }

    public void alarmFailed(Alarm alarm, List<JobUserInfoEntity> targetUserList) {
        this.POOL.execute(() -> this.BEANS.forEach(alarmable -> {
            try {
                alarmable.onFailed(alarm, targetUserList);
            }
            catch (Exception e) {
                log.warn("[AlarmCenter] alarm failed.", (Throwable)e);
            }
        }));
    }
}

