/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.workerfilter;

import com.jxdinfo.hussar.support.job.core.model.SystemMetrics;
import com.jxdinfo.hussar.support.job.dispatch.api.entity.JobInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.common.module.WorkerInfo;
import com.jxdinfo.hussar.support.job.dispatch.extension.WorkerFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SystemMetricsWorkerFilter
implements WorkerFilter {
    private static Logger log = LoggerFactory.getLogger(SystemMetricsWorkerFilter.class);

    @Override
    public boolean filter(WorkerInfo workerInfo, JobInfoEntity jobInfo) {
        boolean filter;
        SystemMetrics metrics = workerInfo.getSystemMetrics();
        boolean bl = filter = !metrics.available(jobInfo.getMinCpuCores().doubleValue(), jobInfo.getMinMemorySpace().doubleValue(), jobInfo.getMinDiskSpace().doubleValue());
        if (filter) {
            log.info("[Job-{}] filter worker[{}] because the {} do not meet the requirements", new Object[]{jobInfo.getId(), workerInfo.getAddress(), workerInfo.getSystemMetrics()});
        }
        return filter;
    }
}

