/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.alram.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.support.job.core.utils.HttpUtils;
import com.jxdinfo.hussar.support.job.dispatch.dao.entity.JobUserInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.extension.Alarmable;
import com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.alram.module.Alarm;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class WebHookAlarmService
implements Alarmable {
    private static Logger log = LoggerFactory.getLogger(WebHookAlarmService.class);
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";

    @Override
    public void onFailed(Alarm alarm, List<JobUserInfoEntity> targetUserList) {
        if (CollectionUtils.isEmpty(targetUserList)) {
            return;
        }
        targetUserList.forEach(user -> {
            String webHook = user.getWebHook();
            if (StringUtils.isEmpty((Object)webHook)) {
                return;
            }
            if (!webHook.startsWith(HTTP_PROTOCOL_PREFIX) && !webHook.startsWith(HTTPS_PROTOCOL_PREFIX)) {
                webHook = HTTP_PROTOCOL_PREFIX + webHook;
            }
            MediaType jsonType = MediaType.parse((String)"application/json; charset=utf-8");
            RequestBody requestBody = RequestBody.create((MediaType)jsonType, (String)JSONObject.toJSONString((Object)alarm));
            try {
                String response = HttpUtils.post((String)webHook, (RequestBody)requestBody);
                log.info("[WebHookAlarmService] invoke webhook[url={}] successfully, response is {}", (Object)webHook, (Object)response);
            }
            catch (Exception e) {
                log.warn("[WebHookAlarmService] invoke webhook[url={}] failed!", (Object)webHook, (Object)e);
            }
        });
    }
}

