/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.alram.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.support.job.core.exception.JobRuntimeException;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.dispatch.common.SJ;
import com.jxdinfo.hussar.support.job.dispatch.dao.entity.JobUserInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.extension.Alarmable;
import com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.alram.impl.DingTalkUtils;
import com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl.alram.module.Alarm;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class DingTalkAlarmService
implements Alarmable {
    private static Logger log = LoggerFactory.getLogger(DingTalkAlarmService.class);
    @Resource
    private Environment environment;
    private Long agentId;
    private DingTalkUtils dingTalkUtils;
    private Cache<String, String> mobile2UserIdCache;
    private static final int CACHE_SIZE = 8192;
    private static final String EMPTY_TAG = "EMPTY";

    @Override
    public void onFailed(Alarm alarm, List<JobUserInfoEntity> targetUserList) {
        if (this.dingTalkUtils == null) {
            return;
        }
        HashSet userIds = Sets.newHashSet();
        targetUserList.forEach(user -> {
            String phone = user.getPhone();
            if (StringUtils.isEmpty((CharSequence)phone)) {
                return;
            }
            try {
                String userId = (String)this.mobile2UserIdCache.get((Object)phone, () -> {
                    try {
                        return this.dingTalkUtils.fetchUserIdByMobile(phone);
                    }
                    catch (JobRuntimeException ignore) {
                        return EMPTY_TAG;
                    }
                    catch (Exception ignore) {
                        return null;
                    }
                });
                if (!EMPTY_TAG.equals(userId)) {
                    userIds.add(userId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        userIds.remove(null);
        if (!userIds.isEmpty()) {
            String userListStr = SJ.COMMA_JOINER.skipNulls().join((Iterable)userIds);
            LinkedList markdownEntities = Lists.newLinkedList();
            markdownEntities.add(new DingTalkUtils.MarkdownEntity("server", NetUtils.getLocalHost()));
            String content = alarm.fetchContent().replaceAll("\r\n", ",");
            markdownEntities.add(new DingTalkUtils.MarkdownEntity("content", content));
            try {
                this.dingTalkUtils.sendMarkdownAsync(alarm.fetchTitle(), markdownEntities, userListStr, this.agentId);
            }
            catch (Exception e) {
                log.error("[DingTalkAlarmService] send ding message failed, reason is {}", (Object)e.getMessage());
            }
        }
    }

    @PostConstruct
    public void init() {
        String agentId = this.environment.getProperty("oms.alarm.ding.agent-id");
        String appKey = this.environment.getProperty("oms.alarm.ding.app-key");
        String appSecret = this.environment.getProperty("oms.alarm.ding.app-secret");
        log.info("[DingTalkAlarmService] init with appKey:{},appSecret:{},agentId:{}", new Object[]{appKey, appSecret, agentId});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{agentId, appKey, appSecret})) {
            log.warn("[DingTalkAlarmService] cannot get agentId, appKey, appSecret at the same time, this service is unavailable");
            return;
        }
        if (!StringUtils.isNumeric((CharSequence)agentId)) {
            log.warn("[DingTalkAlarmService] DingTalkAlarmService is unavailable due to invalid agentId: {}", (Object)agentId);
            return;
        }
        this.agentId = Long.valueOf(agentId);
        this.dingTalkUtils = new DingTalkUtils(appKey, appSecret);
        this.mobile2UserIdCache = CacheBuilder.newBuilder().maximumSize(8192L).build();
        log.info("[DingTalkAlarmService] init DingTalkAlarmService successfully!");
    }
}

