/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.extension.defaultimpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.support.job.core.utils.CommonUtils;
import com.jxdinfo.hussar.support.job.core.utils.NetUtils;
import com.jxdinfo.hussar.support.job.dispatch.dao.entity.JobOmsLockEntity;
import com.jxdinfo.hussar.support.job.dispatch.dao.service.JobOmsLockService;
import com.jxdinfo.hussar.support.job.dispatch.extension.LockService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class DatabaseLockService
implements LockService {
    private static Logger log = LoggerFactory.getLogger(DatabaseLockService.class);
    private final String ownerIp = NetUtils.getLocalHost();
    private final JobOmsLockService jobOmsLockService;

    @Autowired
    public DatabaseLockService(JobOmsLockService jobOmsLockService) {
        this.jobOmsLockService = jobOmsLockService;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            int num = jobOmsLockService.getBaseMapper().delete((Wrapper)new LambdaQueryWrapper().eq(JobOmsLockEntity::getOwnerIp, (Object)this.ownerIp));
            log.info("[DatabaseLockService] execute shutdown hook, release all lock(owner={},num={})", (Object)this.ownerIp, (Object)num);
        }));
    }

    @Override
    public boolean tryLock(String name, long maxLockTime) {
        JobOmsLockEntity newLock = new JobOmsLockEntity(name, this.ownerIp, Long.valueOf(maxLockTime));
        try {
            this.jobOmsLockService.save((Object)newLock);
            return true;
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
        }
        catch (Exception e) {
            log.warn("[DatabaseLockService] write lock to database failed, lockName = {}.", (Object)name, (Object)e);
        }
        JobOmsLockEntity omsLockDO = (JobOmsLockEntity)this.jobOmsLockService.getOne((Wrapper)new LambdaQueryWrapper().eq(JobOmsLockEntity::getLockName, (Object)name));
        long lockedMillions = System.currentTimeMillis() - DateTimeUtil.toInstant((LocalDateTime)omsLockDO.getCreateTime()).toEpochMilli();
        if (lockedMillions > omsLockDO.getMaxLockTime()) {
            log.warn("[DatabaseLockService] The lock[{}] already timeout, will be unlocked now.", (Object)omsLockDO);
            this.unlock(name);
            return this.tryLock(name, maxLockTime);
        }
        return false;
    }

    @Override
    public void unlock(String name) {
        try {
            CommonUtils.executeWithRetry0(() -> this.jobOmsLockService.remove((Wrapper)new LambdaQueryWrapper().eq(JobOmsLockEntity::getLockName, (Object)name)));
        }
        catch (Exception e) {
            log.error("[DatabaseLockService] unlock {} failed.", (Object)name, (Object)e);
        }
    }
}

