/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.dao.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.job.dispatch.dao.entity.JobInstanceInfoEntity;
import com.jxdinfo.hussar.support.job.dispatch.dao.mapper.JobInstanceInfoMapper;
import com.jxdinfo.hussar.support.job.dispatch.dao.model.InstanceInfoModel;
import com.jxdinfo.hussar.support.job.dispatch.dao.service.JobInstanceInfoService;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service
@HussarDs(value="master")
public class JobInstanceInfoServiceImpl
extends HussarServiceImpl<JobInstanceInfoMapper, JobInstanceInfoEntity>
implements JobInstanceInfoService {
    private static final Pattern SPECIAL_WORD_PATTERN = Pattern.compile("[%_]", 2);
    private final List<Character> symbols = CollectionUtil.ofImmutableList((Object[])new Character[]{Character.valueOf('%'), Character.valueOf('_')});
    private static final Character ESCAPE_SYMBOL = Character.valueOf('|');

    @Override
    public boolean update4TriggerStatus(Long instanceId, Integer status, Long actualTriggerTime, Long finishedTime, String taskTrackerAddress, String result) {
        return this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(HussarUtils.isNotEmpty((Object)status), JobInstanceInfoEntity::getStatus, (Object)status)).set(HussarUtils.isNotEmpty((Object)actualTriggerTime), JobInstanceInfoEntity::getActualTriggerTime, HussarUtils.isNotEmpty((Object)actualTriggerTime) ? DateTimeUtil.toDateTime((long)actualTriggerTime) : null)).set(HussarUtils.isNotEmpty((Object)finishedTime), JobInstanceInfoEntity::getFinishedTime, HussarUtils.isNotEmpty((Object)finishedTime) ? DateTimeUtil.toDateTime((long)finishedTime) : null)).set(HussarUtils.isNotEmpty((Object)taskTrackerAddress), JobInstanceInfoEntity::getTaskTrackerAddress, (Object)taskTrackerAddress)).set(HussarUtils.isNotEmpty((Object)result), JobInstanceInfoEntity::getResult, (Object)result)).eq(JobInstanceInfoEntity::getInstanceId, (Object)instanceId));
    }

    @Override
    public JobInstanceInfoEntity getByInstanceId(Long instanceId) {
        return (JobInstanceInfoEntity)((Object)this.getOne((Wrapper)new LambdaQueryWrapper().eq(JobInstanceInfoEntity::getInstanceId, (Object)instanceId)));
    }

    @Override
    public Page<InstanceInfoModel> getPage(Page<InstanceInfoModel> page, InstanceInfoModel model) {
        String jobName = model.getJobName();
        if (HussarUtils.isNotEmpty((Object)jobName) && SPECIAL_WORD_PATTERN.matcher(jobName).find()) {
            jobName = this.resolveParameter(jobName);
            model.setJobName(jobName);
        }
        return ((JobInstanceInfoMapper)this.baseMapper).getPage(page, model);
    }

    private String resolveParameter(String name) {
        StringBuilder sb = new StringBuilder();
        Character pre = Character.valueOf(' ');
        char[] cArray = name.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character cur = Character.valueOf(cArray[i]);
            if (this.symbols.contains(cur) && pre != ESCAPE_SYMBOL) {
                sb.append(ESCAPE_SYMBOL);
            }
            pre = cur;
            sb.append(cur);
        }
        return sb.toString();
    }
}

