/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.common.module;

import com.jxdinfo.hussar.support.job.core.model.DeployedContainerInfo;
import com.jxdinfo.hussar.support.job.core.model.SystemMetrics;
import com.jxdinfo.hussar.support.job.core.request.WorkerHeartbeat;
import java.util.List;

public class WorkerInfo {
    private String address;
    private long lastActiveTime;
    private String protocol;
    private String client;
    private String tag;
    private SystemMetrics systemMetrics;
    private List<DeployedContainerInfo> containerInfos;
    private static final long WORKER_TIMEOUT_MS = 60000L;

    public void refresh(WorkerHeartbeat workerHeartbeat) {
        this.address = workerHeartbeat.getWorkerAddress();
        this.lastActiveTime = workerHeartbeat.getHeartbeatTime();
        this.protocol = workerHeartbeat.getProtocol();
        this.client = workerHeartbeat.getClient();
        this.tag = workerHeartbeat.getTag();
        this.systemMetrics = workerHeartbeat.getSystemMetrics();
        this.containerInfos = workerHeartbeat.getContainerInfos();
    }

    public boolean timeout() {
        long timeout = System.currentTimeMillis() - this.lastActiveTime;
        return timeout > 60000L;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void setLastActiveTime(long lastActiveTime) {
        this.lastActiveTime = lastActiveTime;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public SystemMetrics getSystemMetrics() {
        return this.systemMetrics;
    }

    public void setSystemMetrics(SystemMetrics systemMetrics) {
        this.systemMetrics = systemMetrics;
    }

    public List<DeployedContainerInfo> getContainerInfos() {
        return this.containerInfos;
    }

    public void setContainerInfos(List<DeployedContainerInfo> containerInfos) {
        this.containerInfos = containerInfos;
    }
}

