/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.common.utils;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.List;
import org.apache.commons.net.ntp.NTPUDPClient;
import org.apache.commons.net.ntp.NtpV3Packet;
import org.apache.commons.net.ntp.TimeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtils {
    private static Logger log = LoggerFactory.getLogger(TimeUtils.class);
    private static final List<String> NTP_SERVER_LIST = Lists.newArrayList((Object[])new String[]{"ntp.aliyun.com", "ntp.sjtu.edu.cn", "time1.apple.com"});
    private static final long MAX_OFFSET = 5000L;

    public static void check() throws TimeCheckException {
        try (NTPUDPClient timeClient = new NTPUDPClient();){
            timeClient.setDefaultTimeout(5000);
            for (String address : NTP_SERVER_LIST) {
                try {
                    TimeInfo t = timeClient.getTime(InetAddress.getByName(address));
                    NtpV3Packet ntpV3Packet = t.getMessage();
                    log.info("[TimeUtils] use ntp server: {}, request result: {}", (Object)address, (Object)ntpV3Packet);
                    long local = System.currentTimeMillis();
                    long ntp = ntpV3Packet.getTransmitTimeStamp().getTime();
                    long offset = local - ntp;
                    if (Math.abs(offset) > 5000L) {
                        String msg = String.format("inaccurate server time(local:%d, ntp:%d), please use ntp update to calibration time", local, ntp);
                        throw new TimeCheckException(msg);
                    }
                    return;
                }
                catch (Exception ignore) {
                    log.warn("[TimeUtils] ntp server: {} may down!", (Object)address);
                }
            }
            throw new TimeCheckException("no available ntp server, maybe alibaba, sjtu and apple are both collapse");
        }
    }

    public static final class TimeCheckException
    extends RuntimeException {
        public TimeCheckException(String message) {
            super(message);
        }
    }
}

