/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.job.dispatch.common;

import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectedExecutionHandlerFactory {
    private static Logger log = LoggerFactory.getLogger(RejectedExecutionHandlerFactory.class);
    private static final AtomicLong COUNTER = new AtomicLong();

    public static RejectedExecutionHandler newReject(String source) {
        return (r, p) -> {
            log.error("[{}] ThreadPool[{}] overload, the task[{}] will be dropped!", new Object[]{source, p, r});
            log.warn("[{}] Maybe you need to adjust the ThreadPool config!", (Object)source);
        };
    }

    public static RejectedExecutionHandler newCallerRun(String source) {
        return (r, p) -> {
            log.warn("[{}] ThreadPool[{}] overload, the task[{}] will run by caller thread!", new Object[]{source, p, r});
            log.warn("[{}] Maybe you need to adjust the ThreadPool config!", (Object)source);
            if (!p.isShutdown()) {
                r.run();
            }
        };
    }

    public static RejectedExecutionHandler newThreadRun(String source) {
        return (r, p) -> {
            log.warn("[{}] ThreadPool[{}] overload, the task[{}] will run by a new thread!", new Object[]{source, p, r});
            log.warn("[{}] Maybe you need to adjust the ThreadPool config!", (Object)source);
            if (!p.isShutdown()) {
                String threadName = source + "-T-" + COUNTER.getAndIncrement();
                log.info("[{}] create new thread[{}] to run job", (Object)source, (Object)threadName);
                new Thread(r, threadName).start();
            }
        };
    }
}

