/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.websocket.support.handler;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.TypeUtil;
import com.jxdinfo.hussar.support.websocket.support.listener.WebSocketMessageListener;
import com.jxdinfo.hussar.support.websocket.support.message.JsonWebSocketMessage;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class JsonWebSocketMessageHandler
extends TextWebSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(JsonWebSocketMessageHandler.class);
    private final Map<String, WebSocketMessageListener<Object>> listeners = new HashMap<String, WebSocketMessageListener<Object>>();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        super.afterConnectionEstablished(session);
    }

    protected void handlePongMessage(WebSocketSession session, PongMessage message) throws Exception {
        super.handlePongMessage(session, message);
    }

    public boolean supportsPartialMessages() {
        return super.supportsPartialMessages();
    }

    public JsonWebSocketMessageHandler(List<? extends WebSocketMessageListener> listenersList) {
        listenersList.forEach(listener -> this.listeners.put(listener.getType(), (WebSocketMessageListener<Object>)listener));
    }

    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        if (message.getPayloadLength() == 0) {
            return;
        }
        if (message.getPayloadLength() == 4 && Objects.equals(message.getPayload(), "ping")) {
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)"pong"));
            return;
        }
        try {
            JsonWebSocketMessage jsonMessage = (JsonWebSocketMessage)JsonUtil.parse((String)((String)message.getPayload()), JsonWebSocketMessage.class);
            if (jsonMessage == null) {
                logger.error("[handleTextMessage][session({}) message({}) \u89e3\u6790\u4e3a\u7a7a]", (Object)session.getId(), message.getPayload());
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)"handleTextMessage\u89e3\u6790\u6d88\u606f\u5931\u8d25"));
                return;
            }
            if (HussarUtils.isEmpty((Object)jsonMessage.getType())) {
                logger.error("[handleTextMessage][session({}) message({}) \u7c7b\u578b\u4e3a\u7a7a]", (Object)session.getId(), message.getPayload());
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)"handleTextMessage\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a"));
                return;
            }
            WebSocketMessageListener<Object> messageListener = this.listeners.get(jsonMessage.getType());
            if (messageListener == null) {
                logger.error("[handleTextMessage][session({}) message({}) \u76d1\u542c\u5668\u4e3a\u7a7a]", (Object)session.getId(), message.getPayload());
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)("handleTextMessage\u4e0d\u652f\u6301\u6b64\u4e2d\u6d88\u606f\u7c7b\u578b[" + jsonMessage.getType() + "]\uff0c\u8bf7\u589e\u52a0\u5bf9\u5e94\u76d1\u542c\u5668")));
                return;
            }
            Type type = TypeUtil.getTypeArgument(messageListener.getClass(), (int)0);
            if (type instanceof Class && type == String.class) {
                messageListener.onMessage(session, jsonMessage.getContent());
            } else {
                Object messageObj = JsonUtil.parse((String)jsonMessage.getContent(), (Type)type);
                messageListener.onMessage(session, messageObj);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)"handleTextMessage\u5904\u7406\u5f02\u5e38"));
            logger.error("[handleTextMessage][session({}) message({}) \u5904\u7406\u5f02\u5e38]", (Object)session.getId(), message.getPayload());
        }
    }
}

