/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.websocket.config;

import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.support.websocket.config.WebSocketProperties;
import com.jxdinfo.hussar.support.websocket.listener.HussarDefaultWebSocketMessageListener;
import com.jxdinfo.hussar.support.websocket.support.domessage.HussarMessageCallBack;
import com.jxdinfo.hussar.support.websocket.support.handler.JsonWebSocketMessageHandler;
import com.jxdinfo.hussar.support.websocket.support.listener.WebSocketMessageListener;
import com.jxdinfo.hussar.support.websocket.support.security.LoginUserHandshakeInterceptor;
import com.jxdinfo.hussar.support.websocket.support.sender.WebSocketMessageSender;
import com.jxdinfo.hussar.support.websocket.support.sender.local.LocalWebSocketMessageSender;
import com.jxdinfo.hussar.support.websocket.support.session.WebSocketSessionHandlerDecorator;
import com.jxdinfo.hussar.support.websocket.support.session.WebSocketSessionManager;
import com.jxdinfo.hussar.support.websocket.support.session.WebSocketSessionManagerImpl;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.server.HandshakeInterceptor;

@EnableWebSocket
@ConditionalOnProperty(prefix="hussar.websocket", name={"enable"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={WebSocketProperties.class})
@Configuration
public class HussarWebSocketAutoConfiguration {
    @Bean
    public WebSocketConfigurer webSocketConfigurer(HandshakeInterceptor[] handshakeInterceptors, WebSocketHandler webSocketHandler, WebSocketProperties webSocketProperties) {
        return registry -> registry.addHandler(webSocketHandler, new String[]{webSocketProperties.getPath()}).addInterceptors(handshakeInterceptors).setAllowedOrigins(new String[]{"*"});
    }

    @Bean
    public HandshakeInterceptor handshakeInterceptor(GetLoginUserService getLoginUserService) {
        return new LoginUserHandshakeInterceptor(getLoginUserService);
    }

    @Bean
    public WebSocketHandler webSocketHandler(WebSocketSessionManager sessionManager, List<? extends WebSocketMessageListener<?>> messageListeners) {
        JsonWebSocketMessageHandler messageHandler = new JsonWebSocketMessageHandler(messageListeners);
        return new WebSocketSessionHandlerDecorator((WebSocketHandler)messageHandler, sessionManager);
    }

    @Bean
    public WebSocketSessionManager webSocketSessionManager() {
        return new WebSocketSessionManagerImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public HussarMessageCallBack hussarMessageCallBack() {
        return new HussarMessageCallBack(){

            @Override
            public void receiveMessageCallBack(WebSocketSession currentSession, WebSocketMessageSender webSocketMessageSender, String content) {
                HussarMessageCallBack.super.receiveMessageCallBack(currentSession, webSocketMessageSender, content);
            }
        };
    }

    @Bean
    public HussarDefaultWebSocketMessageListener hussarDefaultWebSocketMessageListener(HussarMessageCallBack hussarMessageCallBack) {
        return new HussarDefaultWebSocketMessageListener(hussarMessageCallBack);
    }

    @Configuration
    @ConditionalOnProperty(prefix="hussar.websocket", name={"senderType"}, havingValue="local", matchIfMissing=true)
    public class LocalWebSocketMessageSenderConfiguration {
        @Bean
        public WebSocketMessageSender localWebSocketMessageSender(WebSocketSessionManager sessionManager) {
            return new LocalWebSocketMessageSender(sessionManager);
        }
    }
}

