/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.websocket.support.security;

import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.websocket.support.util.WebSocketFrameworkUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class LoginUserHandshakeInterceptor
implements HandshakeInterceptor {
    private static Logger logger = LoggerFactory.getLogger(LoginUserHandshakeInterceptor.class);
    private GetLoginUserService getLoginUserService;

    public LoginUserHandshakeInterceptor(GetLoginUserService getLoginUserService) {
        this.getLoginUserService = getLoginUserService;
    }

    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        logger.info("********************************* [beforehandshake] websocket \u8fdb\u5165 beforeHandshake \u65b9\u6cd5 *********************************");
        UserDetails loginUser = this.getLoginUserService.getCurrentUserDetail();
        if (HussarUtils.isNotEmpty((Object)loginUser)) {
            WebSocketFrameworkUtils.setLoginUser(loginUser, attributes);
        }
        return true;
    }

    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception exception) {
        logger.info("********************************* [afterHandshake] websocket \u8fdb\u5165 afterHandshake \u65b9\u6cd5*********************************");
    }
}

