/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.thread.core;

import com.jxdinfo.hussar.support.thread.ext.HandlerServiceLoader;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public enum RejectedExecutionHandlerEnum {
    CallerRuns("callerRuns", ThreadPoolExecutor.CallerRunsPolicy.class),
    Abort("abort", ThreadPoolExecutor.AbortPolicy.class),
    Discard("discard", ThreadPoolExecutor.DiscardPolicy.class),
    DiscardOldest("discardOldest", ThreadPoolExecutor.DiscardOldestPolicy.class),
    Custom("custom", null);

    private final String key;
    private final Class<? extends RejectedExecutionHandler> value;

    private RejectedExecutionHandlerEnum(String key, Class<? extends RejectedExecutionHandler> value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public Class<? extends RejectedExecutionHandler> getValue() {
        return this.value;
    }

    public static Class<? extends RejectedExecutionHandler> resolveByKey(String key) {
        RejectedExecutionHandlerEnum[] enums;
        if (Objects.isNull(key)) {
            return null;
        }
        for (RejectedExecutionHandlerEnum e : enums = RejectedExecutionHandlerEnum.values()) {
            if (!Objects.equals(e.getKey(), key)) continue;
            return e.getValue();
        }
        return null;
    }

    public static RejectedExecutionHandler instantiationHandler(String key) {
        RejectedExecutionHandler handler;
        if (Objects.equals(key, RejectedExecutionHandlerEnum.Custom.key)) {
            return HandlerServiceLoader.loadHandler();
        }
        Class<? extends RejectedExecutionHandler> clazz = RejectedExecutionHandlerEnum.resolveByKey(key);
        try {
            handler = clazz == null ? CallerRuns.getValue().newInstance() : clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return handler;
    }
}

