/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.thread.config;

import com.jxdinfo.hussar.support.thread.config.HussarTpProperties;
import com.jxdinfo.hussar.support.thread.core.RejectedExecutionHandlerEnum;
import com.jxdinfo.hussar.support.thread.support.custom.DefaultSyncCustomAction;
import com.jxdinfo.hussar.support.thread.support.custom.HussarSyncCustomAction;
import com.jxdinfo.hussar.support.thread.support.executor.HussarTaskExecutor;
import com.jxdinfo.hussar.support.thread.support.executor.HussarThreadPoolTaskScheduler;
import com.jxdinfo.hussar.support.thread.support.interceptor.HussarThreadInterceptor;
import com.jxdinfo.hussar.support.thread.support.taskdecorator.HussarTaskDecorator;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class HussarTaskExecutorConfiguration
implements WebMvcConfigurer {
    @Resource
    private HussarTpProperties hussarTpProperties;

    @ConditionalOnMissingBean
    @Bean
    public HussarSyncCustomAction defaultSyncCustomAction() {
        return new DefaultSyncCustomAction();
    }

    @ConditionalOnMissingBean
    @Bean
    public HussarTaskExecutor hussarTaskExecutor(HussarSyncCustomAction syncCustomAction) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.hussarTpProperties.getCorePoolSize());
        threadPoolTaskExecutor.setMaxPoolSize(this.hussarTpProperties.getMaxPoolSize());
        threadPoolTaskExecutor.setQueueCapacity(this.hussarTpProperties.getQueueCapacity());
        threadPoolTaskExecutor.setKeepAliveSeconds(60);
        RejectedExecutionHandlerEnum handler = this.hussarTpProperties.getRejectedExecutionHandler();
        if (handler == null) {
            threadPoolTaskExecutor.setRejectedExecutionHandler(RejectedExecutionHandlerEnum.instantiationHandler(null));
        } else {
            threadPoolTaskExecutor.setRejectedExecutionHandler(RejectedExecutionHandlerEnum.instantiationHandler(handler.getKey()));
        }
        threadPoolTaskExecutor.setTaskDecorator((TaskDecorator)new HussarTaskDecorator(syncCustomAction));
        threadPoolTaskExecutor.setThreadNamePrefix("task-async-");
        threadPoolTaskExecutor.initialize();
        HussarThreadPoolTaskScheduler threadPoolTaskScheduler = new HussarThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(this.hussarTpProperties.getCorePoolSize());
        threadPoolTaskScheduler.setDaemon(true);
        threadPoolTaskScheduler.setTaskDecorator(new HussarTaskDecorator(syncCustomAction));
        threadPoolTaskScheduler.setThreadNamePrefix("job-async-");
        threadPoolTaskScheduler.initialize();
        return new HussarTaskExecutor(threadPoolTaskExecutor, threadPoolTaskScheduler, syncCustomAction);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new HussarThreadInterceptor()).addPathPatterns(new String[]{"/**"});
    }
}

