/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.standalone;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.support.mq.HussarMQManager;
import com.jxdinfo.hussar.support.mq.consumer.HussarMQConsumerBuilder;
import com.jxdinfo.hussar.support.mq.lifecycle.HussarMQAbstractLifecycleManager;
import com.jxdinfo.hussar.support.mq.lifecycle.HussarMQLifecycleManager;
import com.jxdinfo.hussar.support.mq.producer.HussarMQProducerBuilder;
import com.jxdinfo.hussar.support.mq.shared.HussarMQObjectMapper;
import com.jxdinfo.hussar.support.mq.standalone.consumer.HussarStandaloneMQConsumerBuilder;
import com.jxdinfo.hussar.support.mq.standalone.producer.HussarStandaloneMQProducerBuilder;
import com.jxdinfo.hussar.support.mq.standalone.queue.HussarMQMemoryQueue;
import com.jxdinfo.hussar.support.mq.standalone.queue.HussarMQStandaloneQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.springframework.lang.NonNull;
import org.springframework.util.ConcurrentReferenceHashMap;

public class HussarStandaloneMQManager
extends HussarMQAbstractLifecycleManager
implements HussarMQManager {
    private final ObjectMapper objectMapper;
    private final ExecutorService executorService;
    private final ConcurrentMap<String, HussarMQStandaloneQueue> queueMap = new ConcurrentReferenceHashMap();

    public HussarStandaloneMQManager(@NonNull ExecutorService executorService) {
        this((ObjectMapper)new HussarMQObjectMapper(), executorService);
    }

    public HussarStandaloneMQManager(@NonNull ObjectMapper objectMapper, @NonNull ExecutorService executorService) {
        this.objectMapper = objectMapper;
        this.executorService = executorService;
    }

    @NonNull
    public <T> HussarMQProducerBuilder<T> newProducer(@NonNull String key) {
        HussarMQStandaloneQueue queue = this.getQueue(key);
        return new HussarStandaloneMQProducerBuilder((HussarMQLifecycleManager)this, this.objectMapper, queue, key);
    }

    @NonNull
    public <T> HussarMQConsumerBuilder<T> newConsumer(@NonNull String key) {
        HussarMQStandaloneQueue queue = this.getQueue(key);
        return new HussarStandaloneMQConsumerBuilder((HussarMQLifecycleManager)this, this.objectMapper, this.executorService, queue, key);
    }

    protected HussarMQStandaloneQueue getQueue(@NonNull String key) {
        return this.queueMap.computeIfAbsent(key, HussarMQMemoryQueue::new);
    }

    protected void doStop() {
        super.doStop();
        this.executorService.shutdownNow();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HussarStandaloneMQManager<").append(this.getLifecycleStateName());
        if (this.declaring) {
            builder.append(" [declaring]");
        }
        builder.append(" queues").append(this.queueMap.keySet()).append('>');
        return builder.toString();
    }
}

