/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.redis.config;

import com.jxdinfo.hussar.support.mq.redis.constants.HussarRedisMQConstants;
import java.time.Duration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="hussar.mq.redis")
public class HussarRedisMQProperties {
    public static final String PREFIX = "hussar.mq.redis";
    public static final String CONNECTION_PREFIX = "hussar.mq.redis.connection";
    private RedisConnectionProperties connection = new RedisConnectionProperties();
    private long limit = 100000L;
    private boolean autoCompress = false;
    private DataSize compressThreshold = DataSize.ofMegabytes((long)1L);
    private Duration fetchConnectionInterval = HussarRedisMQConstants.DEFAULT_INTERVAL;
    private boolean pollWorkerAutoRestart = true;
    private Duration pollWorkerRestartInterval = HussarRedisMQConstants.DEFAULT_RESTART_INTERVAL;
    private Duration pollWorkerStartTimeout = HussarRedisMQConstants.DEFAULT_START_TIMEOUT;
    private Duration pollWorkerStopTimeout = HussarRedisMQConstants.DEFAULT_STOP_TIMEOUT;
    private Duration pollInitialDelay = Duration.ofSeconds(0L);
    private Duration pollInterval = HussarRedisMQConstants.DEFAULT_INTERVAL;
    private Integer pollCount = 5;
    private boolean checkAlways = true;
    private int checkLength = 5;
    private Duration checkInterval = HussarRedisMQConstants.DEFAULT_INTERVAL;
    private Duration retryTimeout = HussarRedisMQConstants.DEFAULT_TIMEOUT;
    private int retryCount = 3;
    private int deadLetterLimit = 1000;
    private Duration acknowledgeInterval = Duration.ofMillis(50L);
    private int acknowledgeCount = 5;

    public RedisConnectionProperties getConnection() {
        return this.connection;
    }

    public void setConnection(RedisConnectionProperties connection) {
        this.connection = connection;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public boolean isAutoCompress() {
        return this.autoCompress;
    }

    public void setAutoCompress(boolean autoCompress) {
        this.autoCompress = autoCompress;
    }

    public DataSize getCompressThreshold() {
        return this.compressThreshold;
    }

    public void setCompressThreshold(DataSize compressThreshold) {
        this.compressThreshold = compressThreshold;
    }

    public boolean isPollWorkerAutoRestart() {
        return this.pollWorkerAutoRestart;
    }

    public void setPollWorkerAutoRestart(boolean pollWorkerAutoRestart) {
        this.pollWorkerAutoRestart = pollWorkerAutoRestart;
    }

    public Duration getPollWorkerRestartInterval() {
        return this.pollWorkerRestartInterval;
    }

    public void setPollWorkerRestartInterval(Duration pollWorkerRestartInterval) {
        this.pollWorkerRestartInterval = pollWorkerRestartInterval;
    }

    public Duration getPollWorkerStartTimeout() {
        return this.pollWorkerStartTimeout;
    }

    public void setPollWorkerStartTimeout(Duration pollWorkerStartTimeout) {
        this.pollWorkerStartTimeout = pollWorkerStartTimeout;
    }

    public Duration getPollWorkerStopTimeout() {
        return this.pollWorkerStopTimeout;
    }

    public void setPollWorkerStopTimeout(Duration pollWorkerStopTimeout) {
        this.pollWorkerStopTimeout = pollWorkerStopTimeout;
    }

    public Duration getFetchConnectionInterval() {
        return this.fetchConnectionInterval;
    }

    public void setFetchConnectionInterval(Duration fetchConnectionInterval) {
        this.fetchConnectionInterval = fetchConnectionInterval;
    }

    public Duration getPollInitialDelay() {
        return this.pollInitialDelay;
    }

    public void setPollInitialDelay(Duration pollInitialDelay) {
        this.pollInitialDelay = pollInitialDelay;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public void setPollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval;
    }

    public Integer getPollCount() {
        return this.pollCount;
    }

    public void setPollCount(Integer pollCount) {
        this.pollCount = pollCount;
    }

    public boolean isCheckAlways() {
        return this.checkAlways;
    }

    public void setCheckAlways(boolean checkAlways) {
        this.checkAlways = checkAlways;
    }

    public int getCheckLength() {
        return this.checkLength;
    }

    public void setCheckLength(int checkLength) {
        this.checkLength = checkLength;
    }

    public Duration getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(Duration checkInterval) {
        this.checkInterval = checkInterval;
    }

    public Duration getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(Duration retryTimeout) {
        this.retryTimeout = retryTimeout;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getDeadLetterLimit() {
        return this.deadLetterLimit;
    }

    public void setDeadLetterLimit(int deadLetterLimit) {
        this.deadLetterLimit = deadLetterLimit;
    }

    public Duration getAcknowledgeInterval() {
        return this.acknowledgeInterval;
    }

    public void setAcknowledgeInterval(Duration acknowledgeInterval) {
        this.acknowledgeInterval = acknowledgeInterval;
    }

    public int getAcknowledgeCount() {
        return this.acknowledgeCount;
    }

    public void setAcknowledgeCount(int acknowledgeCount) {
        this.acknowledgeCount = acknowledgeCount;
    }

    public static class RedisConnectionProperties
    extends RedisProperties {
        private boolean useDefault = true;
        private String redisCluster = null;

        public boolean isUseDefault() {
            return this.useDefault;
        }

        public void setUseDefault(boolean useDefault) {
            this.useDefault = useDefault;
        }

        public String getRedisCluster() {
            return this.redisCluster;
        }

        public void setRedisCluster(String redisCluster) {
            this.redisCluster = redisCluster;
        }
    }
}

