/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.redis.message;

import com.jxdinfo.hussar.support.mq.redis.message.HussarRedisMQMessageCodec;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;

public class HussarRedisMQMessage<T> {
    private static final String FIELD_DATA = "data";
    private static final String FIELD_ENCODING = "encoding";
    private T data;
    private String encoding;
    private Map<String, Object> metadata;

    public HussarRedisMQMessage() {
    }

    private HussarRedisMQMessage(T data, String encoding, Map<String, Object> metadata) {
        this.data = data;
        this.encoding = encoding;
        this.metadata = metadata;
    }

    public static <T> HussarRedisMQMessage<T> of(T data) {
        return new HussarRedisMQMessage<T>(data, null, null);
    }

    public static <T> HussarRedisMQMessage<T> fromByteRecord(HussarRedisMQMessageCodec messageCodec, Type type, ByteRecord record) {
        String encoding = null;
        byte[] encodedData = null;
        LinkedHashMap<String, Object> metadata = null;
        for (Map.Entry entry : record) {
            String key = messageCodec.fromRawKey((byte[])entry.getKey());
            if (FIELD_ENCODING.equals(key)) {
                encoding = messageCodec.fromRawValue((byte[])entry.getValue(), String.class);
                continue;
            }
            if (FIELD_DATA.equals(key)) {
                encodedData = (byte[])entry.getValue();
                continue;
            }
            if (metadata == null) {
                metadata = new LinkedHashMap<String, Object>();
            }
            Object value = messageCodec.fromRawValue((byte[])entry.getValue());
            metadata.put(key, value);
        }
        HussarRedisMQMessage message = new HussarRedisMQMessage();
        byte[] rawData = messageCodec.decodeData(encodedData, encoding);
        Object data = messageCodec.fromRawValue(rawData, type);
        message.setData(data);
        message.setMetadata(metadata);
        return message;
    }

    public ByteRecord toByteRecord(HussarRedisMQMessageCodec messageCodec) {
        byte[] rawData = messageCodec.toRawValue(this.data);
        String encoding = messageCodec.getSuggestedEncoding(rawData, this.encoding);
        byte[] encodedData = messageCodec.encodeData(rawData, encoding);
        LinkedHashMap<byte[], byte[]> map = new LinkedHashMap<byte[], byte[]>();
        if (encoding != null) {
            map.put(messageCodec.toRawKey(FIELD_ENCODING), messageCodec.toRawValue(encoding));
        }
        if (this.metadata != null) {
            for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
                map.put(messageCodec.toRawKey(entry.getKey()), messageCodec.toRawValue(entry.getValue()));
            }
        }
        map.put(messageCodec.toRawKey(FIELD_DATA), encodedData);
        return StreamRecords.rawBytes(map);
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HussarRedisMQMessage[");
        if (this.encoding != null) {
            builder.append(FIELD_ENCODING).append("=").append(this.encoding).append(", ");
        }
        if (this.metadata != null) {
            for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
                builder.append(entry.getKey()).append("=").append(entry.getValue()).append(", ");
            }
        }
        builder.append(FIELD_DATA).append("=").append(this.data).append("]");
        return builder.toString();
    }
}

