/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mq.redis;

import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.support.mq.HussarMQManager;
import com.jxdinfo.hussar.support.mq.consumer.HussarMQConsumerBuilder;
import com.jxdinfo.hussar.support.mq.lifecycle.HussarMQAbstractLifecycleManager;
import com.jxdinfo.hussar.support.mq.lifecycle.HussarMQLifecycleManager;
import com.jxdinfo.hussar.support.mq.producer.HussarMQProducerBuilder;
import com.jxdinfo.hussar.support.mq.redis.config.HussarRedisMQProperties;
import com.jxdinfo.hussar.support.mq.redis.consumer.HussarRedisMQConsumerBuilder;
import com.jxdinfo.hussar.support.mq.redis.message.HussarRedisMQMessageCodec;
import com.jxdinfo.hussar.support.mq.redis.producer.HussarRedisMQProducerBuilder;
import com.jxdinfo.hussar.support.mq.redis.utils.HussarRedisMQUtils;
import java.util.concurrent.ExecutorService;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class HussarRedisMQManager
extends HussarMQAbstractLifecycleManager
implements HussarMQManager {
    private final HussarRedisMQProperties properties;
    private final RedisTemplate<String, Object> redisTemplate;
    private final HussarRedisMQMessageCodec messageCodec;
    private final ExecutorService executorService;
    private final SeqBuilder hussarSeqBuilder;

    public HussarRedisMQManager(@NonNull HussarRedisMQProperties properties, @NonNull RedisTemplate<String, Object> redisTemplate, @NonNull HussarRedisMQMessageCodec messageCodec, @NonNull ExecutorService executorService, @Nullable SeqBuilder hussarSeqBuilder) {
        this.properties = properties;
        this.redisTemplate = redisTemplate;
        this.messageCodec = messageCodec;
        this.executorService = executorService;
        this.hussarSeqBuilder = hussarSeqBuilder;
    }

    @NonNull
    public <T> HussarMQProducerBuilder<T> newProducer(@NonNull String key) {
        return new HussarRedisMQProducerBuilder((HussarMQLifecycleManager)this, this.properties, this.redisTemplate, this.messageCodec, this.getStreamName(key));
    }

    @NonNull
    public <T> HussarMQConsumerBuilder<T> newConsumer(@NonNull String key) {
        Sequence sequence = this.getSequence();
        return new HussarRedisMQConsumerBuilder((HussarMQLifecycleManager)this, this.properties, this.redisTemplate, this.messageCodec, this.executorService, sequence, this.getStreamName(key), key);
    }

    @NonNull
    private String getStreamName(@NonNull String key) {
        return HussarRedisMQUtils.generateStreamName("hussar_mq", "mpmc", key);
    }

    private Sequence getSequence() {
        return this.hussarSeqBuilder != null ? this.hussarSeqBuilder.build() : null;
    }

    protected void doStop() {
        super.doStop();
        this.executorService.shutdownNow();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HussarRedisMQManager<").append(this.getLifecycleStateName());
        if (this.declaring) {
            builder.append(" [declaring]");
        }
        builder.append('>');
        return builder.toString();
    }
}

