/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.base.query.strategy;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.query.dto.FieldMappingDto;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public interface QueryStrategy {
    default public FieldMappingDto transFieldValue(FieldMappingDto fieldMappingDto) {
        Object fieldValue = fieldMappingDto.getFieldValue();
        if (HussarUtils.isEmpty((Object)fieldValue)) {
            return fieldMappingDto;
        }
        String value = fieldValue.toString();
        switch (fieldMappingDto.getFieldClassType().toString()) {
            case "class java.lang.Integer": {
                fieldMappingDto.setFieldValue(Integer.parseInt(value));
                break;
            }
            case "class java.lang.Short": {
                Short parseShort = Short.parseShort(value);
                fieldMappingDto.setFieldValue(parseShort);
                break;
            }
            case "class java.lang.Long": {
                Long parseLong = Long.parseLong(value);
                fieldMappingDto.setFieldValue(parseLong);
                break;
            }
            case "class java.lang.Float": {
                Float parseFloat = Float.valueOf(Float.parseFloat(value));
                fieldMappingDto.setFieldValue(parseFloat);
                break;
            }
            case "class java.lang.Double": {
                Double parseDouble = Double.parseDouble(value);
                fieldMappingDto.setFieldValue(parseDouble);
                break;
            }
            case "class java.math.BigDecimal": {
                BigDecimal bigDecimal = new BigDecimal(value);
                fieldMappingDto.setFieldValue(bigDecimal);
                break;
            }
            case "class java.time.LocalDate": {
                LocalDate localDate = DateTimeUtil.parseDate((String)value);
                fieldMappingDto.setFieldValue(localDate);
                break;
            }
            case "class java.time.LocalDateTime": {
                LocalDateTime localDateTime = DateTimeUtil.parseDateTime((String)value);
                fieldMappingDto.setFieldValue(localDateTime);
                break;
            }
            case "class java.time.LocalTime": {
                LocalTime localTime = DateTimeUtil.parseTime((String)value);
                fieldMappingDto.setFieldValue(localTime);
                break;
            }
            case "class java.lang.Boolean": {
                Boolean booleanValue = Boolean.valueOf(value);
                fieldMappingDto.setFieldValue(booleanValue);
                break;
            }
            default: {
                fieldMappingDto.setFieldValue(value);
            }
        }
        return fieldMappingDto;
    }

    public <T> QueryWrapper<T> joinQueryWrapper(QueryWrapper<T> var1, FieldMappingDto var2);
}

