/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.handler;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusAutoFillProperties;
import com.jxdinfo.hussar.support.mp.handler.FieldFillDto;
import com.jxdinfo.hussar.support.mp.handler.annotations.HussarFieldValue;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.NumberUtils;

public abstract class AbstractHussarMetaObjectHandler
implements MetaObjectHandler {
    public static Map<Class, Map<FieldFill, List<FieldFillDto>>> cacheFillField = new HashMap<Class, Map<FieldFill, List<FieldFillDto>>>();
    private static final Logger log = LoggerFactory.getLogger(AbstractHussarMetaObjectHandler.class);
    protected final MybatisPlusAutoFillProperties autoFillProperties;
    protected GetLoginUserService getLoginUserService;

    public AbstractHussarMetaObjectHandler(MybatisPlusAutoFillProperties autoFillProperties) {
        this.autoFillProperties = autoFillProperties;
    }

    public AbstractHussarMetaObjectHandler(MybatisPlusAutoFillProperties autoFillProperties, GetLoginUserService getLoginUserService) {
        this.autoFillProperties = autoFillProperties;
        this.getLoginUserService = getLoginUserService;
    }

    public boolean openInsertFill() {
        return this.autoFillProperties.getEnabled() != false || this.autoFillProperties.getEnableInsertFill() != false;
    }

    public boolean openUpdateFill() {
        return this.autoFillProperties.getEnabled() != false || this.autoFillProperties.getEnableUpdateFill() != false;
    }

    public void insertFill(MetaObject metaObject) {
        List<FieldFillDto> fieldFillDtoList = this.mergeFieldFillDto(metaObject, FieldFill.INSERT);
        if (HussarUtils.isNotEmpty(fieldFillDtoList)) {
            this.doFillField(metaObject, fieldFillDtoList);
        }
        this.customInsertFill(metaObject);
    }

    public void updateFill(MetaObject metaObject) {
        List<FieldFillDto> fieldFillDtoList = this.mergeFieldFillDto(metaObject, FieldFill.UPDATE);
        if (HussarUtils.isNotEmpty(fieldFillDtoList)) {
            this.doFillField(metaObject, fieldFillDtoList);
        }
        this.customUpdatetFill(metaObject);
    }

    public abstract void customInsertFill(MetaObject var1);

    public abstract void customUpdatetFill(MetaObject var1);

    protected List<FieldFillDto> mergeFieldFillDto(MetaObject metaobject, FieldFill fillType) {
        Map<FieldFill, List<FieldFillDto>> mapClass;
        Class<?> aClass = metaobject.getOriginalObject().getClass();
        if (HussarUtils.isNotEmpty(cacheFillField) && HussarUtils.isNotEmpty(mapClass = cacheFillField.get(aClass)) && HussarUtils.isNotEmpty(mapClass.get(fillType))) {
            return mapClass.get(fillType);
        }
        Map<FieldFill, List<FieldFillDto>> fillHussarFeildMap = this.findFillHussarFeild(metaobject);
        if (HussarUtils.isEmpty(fillHussarFeildMap)) {
            return null;
        }
        List<FieldFillDto> fieldFillDtoList = fillHussarFeildMap.keySet().stream().filter(key -> key == fillType || key == FieldFill.INSERT_UPDATE).map(k -> (List)fillHussarFeildMap.get(k)).flatMap(Collection::stream).collect(Collectors.toList());
        if (HussarUtils.isEmpty(fieldFillDtoList)) {
            return null;
        }
        Map<FieldFill, List<FieldFillDto>> fieldMap = cacheFillField.get(aClass);
        if (HussarUtils.isEmpty(fieldMap)) {
            fieldMap = new HashMap<FieldFill, List<FieldFillDto>>();
            cacheFillField.put(aClass, fieldMap);
            fieldMap.put(fillType, fieldFillDtoList);
        }
        return fieldFillDtoList;
    }

    private Map<FieldFill, List<FieldFillDto>> findFillHussarFeild(MetaObject metaObject) {
        List allFields = TableInfoHelper.getAllFields(metaObject.getOriginalObject().getClass());
        Map<FieldFill, List<FieldFillDto>> fillListMap = allFields.stream().filter(field -> {
            if (field.isAnnotationPresent(HussarFieldValue.class)) {
                TableField annotation = field.getAnnotation(TableField.class);
                return !annotation.fill().equals((Object)FieldFill.DEFAULT);
            }
            return false;
        }).map(field -> {
            HussarFieldValue annotation = field.getAnnotation(HussarFieldValue.class);
            TableField tableFieldAnno = field.getAnnotation(TableField.class);
            FieldFillDto fieldFillDto = new FieldFillDto();
            fieldFillDto.setPropertyName(field.getName());
            fieldFillDto.setPropertyType(field.getType());
            fieldFillDto.setDefaultVaule(annotation.defaultValue());
            fieldFillDto.setMapKey(annotation.userDetailKey());
            fieldFillDto.setFillType(tableFieldAnno.fill());
            fieldFillDto.setForceUpdate(annotation.forceUpdate());
            return fieldFillDto;
        }).collect(Collectors.groupingBy(FieldFillDto::getFillType));
        return fillListMap;
    }

    protected UserDetails getUserDetails() {
        if (HussarUtils.isEmpty((Object)this.getLoginUserService)) {
            log.warn("\u672a\u6ce8\u5165mpGetUserInfoService\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\uff01");
            return null;
        }
        UserDetails userDetails = this.getLoginUserService.getCurrentUserDetail();
        return userDetails;
    }

    public void doFillField(MetaObject metaObject, List<FieldFillDto> fieldFillDtoList) {
        fieldFillDtoList.forEach(fieldFillDto -> {
            Object preValue = this.getFieldValByName(fieldFillDto.getPropertyName(), metaObject);
            if (HussarUtils.isEmpty((Object)preValue) || fieldFillDto.isForceUpdate()) {
                Object postValue = this.getFillValue((FieldFillDto)fieldFillDto);
                this.setFieldValByName(fieldFillDto.getPropertyName(), postValue, metaObject);
            }
        });
    }

    private Object getFillValue(FieldFillDto fieldFillDto) {
        UserDetails userDetails = this.getUserDetails();
        if (HussarUtils.isEmpty((Object)userDetails) || HussarUtils.isEmpty((Object)userDetails.getExtendUserMap(fieldFillDto.getMapKey()))) {
            return this.getDefaultValue(fieldFillDto);
        }
        return userDetails.getExtendUserMap(fieldFillDto.getMapKey());
    }

    private Object getDefaultValue(FieldFillDto fieldFillDto) {
        Object value = null;
        Class<Object> propertyType = fieldFillDto.getPropertyType();
        String defaultVaule = fieldFillDto.getDefaultVaule();
        try {
            if (Number.class.isAssignableFrom(propertyType)) {
                value = NumberUtils.parseNumber((String)defaultVaule, propertyType);
            } else if (propertyType.isAssignableFrom(String.class)) {
                value = defaultVaule;
            } else if (propertyType.isAssignableFrom(LocalDateTime.class) || propertyType.isAssignableFrom(LocalDate.class)) {
                value = LocalDateTime.now();
            }
        }
        catch (Exception e) {
            log.warn("\u516c\u5171\u5b57\u6bb5\u586b\u5145\u83b7\u53d6\u9ed8\u8ba4\u503c\u8f6c\u5316\u5931\u8d25\uff0c\u5f85\u8f6c\u5316\u7684\u503c{},\u8f6c\u5316\u6210\u7c7b\u578b{}", (Object)defaultVaule, propertyType);
        }
        return value;
    }

    public MybatisPlusAutoFillProperties getAutoFillProperties() {
        return this.autoFillProperties;
    }

    public GetLoginUserService getGetLoginUserService() {
        return this.getLoginUserService;
    }

    public void setGetLoginUserService(GetLoginUserService getLoginUserService) {
        this.getLoginUserService = getLoginUserService;
    }

    protected boolean pkIsNull(Object pk) {
        if (pk == null) {
            return true;
        }
        if (pk instanceof String) {
            return HussarUtils.isEmpty((Object)pk);
        }
        if (pk instanceof Long) {
            long longPk = (Long)pk;
            return HussarUtils.isEmpty((Object)longPk) || longPk == 0L;
        }
        return false;
    }

    protected boolean validDefaultFiled(Field field) {
        List<String> defaultFillFieldList = this.autoFillProperties.getDefaultFillFieldList();
        if (HussarUtils.isEmpty(defaultFillFieldList)) {
            return false;
        }
        return defaultFillFieldList.contains(field.getName());
    }
}

