/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.customizer;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusPluginProperties;
import com.jxdinfo.hussar.support.mp.customizer.MybatisPlusInterceptorCustomizer;
import com.jxdinfo.hussar.support.mp.plugins.DatabaseSchemaInterceptor;
import com.jxdinfo.hussar.support.mp.plugins.support.schema.SchemaNameHandler;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;

public class DataSchemaMybatisPlusInterceptorCustomizer
implements MybatisPlusInterceptorCustomizer {
    private MybatisPlusPluginProperties mybatisPlusPluginProperties;

    public DataSchemaMybatisPlusInterceptorCustomizer(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
    }

    @Override
    public void customize(MybatisPlusInterceptor interceptor) {
        SchemaNameHandler schemaNameHandler = (dataSource, sql, tableName) -> {
            StringBuilder stringBuilder = new StringBuilder();
            String[] tableNameArr = HussarUtils.splitTrim((String)tableName, (String)".");
            if (dataSource.getDbType().getDb().equalsIgnoreCase(DbType.MYSQL.getDb()) || tableNameArr.length > 1) {
                return tableName;
            }
            if (HussarUtils.isEmpty((Object)dataSource.getSchemaName())) {
                return tableName;
            }
            if (dataSource.getDbType().getDb().equalsIgnoreCase(DbType.SQL_SERVER.getDb()) || dataSource.getDbType().getDb().equalsIgnoreCase(DbType.SQL_SERVER2005.getDb())) {
                if (MpUtils.enableDoSqlserverPage(sql, tableName)) {
                    return tableName;
                }
                stringBuilder.append("[");
                stringBuilder.append(dataSource.getSchemaName());
                stringBuilder.append("]");
            } else {
                stringBuilder.append("\"");
                stringBuilder.append(dataSource.getSchemaName());
                stringBuilder.append("\"");
            }
            stringBuilder.append(".");
            stringBuilder.append(tableName);
            return stringBuilder.toString();
        };
        DatabaseSchemaInterceptor databaseSchemaInterceptor = new DatabaseSchemaInterceptor(schemaNameHandler, this.mybatisPlusPluginProperties);
        interceptor.addInnerInterceptor((InnerInterceptor)databaseSchemaInterceptor);
    }

    public MybatisPlusPluginProperties getMybatisPlusPluginProperties() {
        return this.mybatisPlusPluginProperties;
    }

    public void setMybatisPlusPluginProperties(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
    }
}

