/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.plugins;

import com.alibaba.druid.DbType;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.SQLUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusPluginProperties;
import com.jxdinfo.hussar.support.mp.exception.MpRuntimeException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlLogInterceptor
extends FilterEventAdapter {
    private static Logger LOGGER = LoggerFactory.getLogger(SqlLogInterceptor.class);
    private static final SQLUtils.FormatOption FORMAT_OPTION = new SQLUtils.FormatOption(false, false);
    private static final List<String> SQL_LOG_EXCLUDE = new ArrayList<String>(Arrays.asList("ACT_RU_JOB", "ACT_RU_TIMER_JOB"));
    private final MybatisPlusPluginProperties properties;

    public SqlLogInterceptor(MybatisPlusPluginProperties properties) {
        this.properties = properties;
        if (properties.getSqlLogExclude().size() > 0) {
            SQL_LOG_EXCLUDE.addAll(properties.getSqlLogExclude());
        }
    }

    protected void statementExecuteBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteBatchBefore(StatementProxy statement) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteUpdateBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteQueryBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteAfter(StatementProxy statement, String sql, boolean firstResult) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteBatchAfter(StatementProxy statement, int[] result) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteQueryAfter(StatementProxy statement, String sql, ResultSetProxy resultSet) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteUpdateAfter(StatementProxy statement, String sql, int updateCount) {
        statement.setLastExecuteTimeNano();
    }

    public void statement_close(FilterChain chain, StatementProxy statement) {
        try {
            if (!this.properties.getSqlLog().booleanValue()) {
                chain.statement_close(statement);
                return;
            }
            if (!LOGGER.isInfoEnabled()) {
                chain.statement_close(statement);
                return;
            }
            String sql = statement.getBatchSql();
            if (StringUtils.isEmpty((CharSequence)sql)) {
                chain.statement_close(statement);
                return;
            }
            if (SqlLogInterceptor.excludeSql(sql)) {
                chain.statement_close(statement);
                return;
            }
            int parametersSize = statement.getParametersSize();
            ArrayList<Object> parameters = new ArrayList<Object>(parametersSize);
            for (int i = 0; i < parametersSize; ++i) {
                JdbcParameter jdbcParam = statement.getParameter(i);
                parameters.add(jdbcParam != null ? jdbcParam.getValue() : null);
            }
            String dbType = statement.getConnectionProxy().getDirectDataSource().getDbType();
            DbType type = HussarUtils.isEmpty((Object)dbType) ? DbType.other : DbType.valueOf((String)dbType);
            String formattedSql = SQLUtils.format((String)sql, (DbType)type, parameters, (SQLUtils.FormatOption)FORMAT_OPTION);
            SqlLogInterceptor.printSql(formattedSql, statement);
            chain.statement_close(statement);
        }
        catch (SQLException sqlException) {
            sqlException.printStackTrace();
            throw new MpRuntimeException(sqlException.getMessage(), sqlException.getCause());
        }
    }

    private static void printSql(String sql, StatementProxy statement) {
        String sqlLogger = "\n\n==============  Sql Start  ==============\nExecute SQL : {}\nExecute Time: {}\n==============  Sql  End   ==============\n";
        LOGGER.info(sqlLogger, (Object)sql.trim(), (Object)StringUtil.format((long)statement.getLastExecuteTimeNano()));
    }

    private static boolean excludeSql(String sql) {
        for (String exclude : SQL_LOG_EXCLUDE) {
            if (!sql.contains(exclude)) continue;
            return true;
        }
        return false;
    }

    static {
        SQL_LOG_EXCLUDE.add("SYS_JOB_CONTAINER_INFO");
        SQL_LOG_EXCLUDE.add("SYS_JOB_INSTANCE_LOG");
        SQL_LOG_EXCLUDE.add("SYS_JOB_INSTANCE_INFO");
        SQL_LOG_EXCLUDE.add("SYS_JOB_OMS_LOCK");
        SQL_LOG_EXCLUDE.add("SYS_JOB_SERVER_INFO");
        SQL_LOG_EXCLUDE.add("SYS_JOB_USER_INFO");
        SQL_LOG_EXCLUDE.add("SYS_JOB_WF_INFO");
        SQL_LOG_EXCLUDE.add("SYS_JOB_WF_INSTANCE_INFO");
        SQL_LOG_EXCLUDE.add("SYS_JOB_WF_NODE_INFO");
        SQL_LOG_EXCLUDE.add("SYS_SUPPORT_AUDIT_LOG");
        SQL_LOG_EXCLUDE.add("SYS_SUPPORT_AUDIT_LOG_TABLE");
        SQL_LOG_EXCLUDE.add("SYS_SUPPORT_AUDIT_LOG_COLUMN");
    }
}

