/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.customizer;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusPluginProperties;
import com.jxdinfo.hussar.support.mp.customizer.MybatisPlusInterceptorCustomizer;
import com.jxdinfo.hussar.support.mp.intercept.QueryInterceptor;
import com.jxdinfo.hussar.support.mp.plugins.HussarPaginationInterceptor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class HussarPaginationInterceptorCustomizer
implements MybatisPlusInterceptorCustomizer {
    private ObjectProvider<QueryInterceptor[]> queryInterceptors;
    private MybatisPlusPluginProperties mybatisPlusProperties;

    public HussarPaginationInterceptorCustomizer(ObjectProvider<QueryInterceptor[]> queryInterceptors, MybatisPlusPluginProperties mybatisPlusProperties) {
        this.queryInterceptors = queryInterceptors;
        this.mybatisPlusProperties = mybatisPlusProperties;
    }

    @Override
    public void customize(MybatisPlusInterceptor interceptor) {
        HussarPaginationInterceptor paginationInterceptor = new HussarPaginationInterceptor();
        Object[] queryInterceptorArray = (QueryInterceptor[])this.queryInterceptors.getIfAvailable();
        if (ObjectUtils.isNotEmpty((Object)queryInterceptorArray)) {
            AnnotationAwareOrderComparator.sort((Object[])queryInterceptorArray);
            paginationInterceptor.setQueryInterceptors((QueryInterceptor[])queryInterceptorArray);
        }
        paginationInterceptor.setMaxLimit(this.mybatisPlusProperties.getPageLimit());
        paginationInterceptor.setOverflow(this.mybatisPlusProperties.getOverflow());
        paginationInterceptor.setOptimizeJoin(this.mybatisPlusProperties.getOptimizeJoin());
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInterceptor);
    }
}

