/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.plugins;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.TableNameParser;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusPluginProperties;
import com.jxdinfo.hussar.support.mp.plugins.support.SchemaDTO;
import com.jxdinfo.hussar.support.mp.plugins.support.schema.SchemaNameHandler;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSchemaInterceptor
implements InnerInterceptor {
    private static Logger logger = LoggerFactory.getLogger(DatabaseSchemaInterceptor.class);
    private SchemaNameHandler schemaNameHandler;
    private MybatisPlusPluginProperties mybatisPlusPluginProperties;

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        SchemaDTO schemaDTO = this.getSchemaDTO(ms);
        if (HussarUtils.isNotEmpty((Object)schemaDTO) && schemaDTO.getSchemaMybatisEnabled().booleanValue()) {
            mpBs.sql(this.doSchemaService(schemaDTO.getItemDataSource(), mpBs.sql()));
        }
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh;
        MappedStatement ms;
        SqlCommandType sct;
        SchemaDTO schemaDTO = this.getSchemaDTO(sh);
        if (HussarUtils.isNotEmpty((Object)schemaDTO) && schemaDTO.getSchemaMybatisEnabled().booleanValue() && ((sct = (ms = (mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh)).mappedStatement()).getSqlCommandType()) == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE || sct == SqlCommandType.SELECT)) {
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.doSchemaService(schemaDTO.getItemDataSource(), mpBs.sql()));
        }
    }

    protected String doSchemaService(ItemDataSource itemDataSource, String sql) {
        logger.debug("doSchemaService \u5904\u7406\u4e4b\u524d\u7684sql=> {}", (Object)StringUtil.removeAllLineBreaks((CharSequence)sql));
        if (HussarUtils.isEmpty((Object)this.schemaNameHandler)) {
            return sql;
        }
        TableNameParser parser = new TableNameParser(sql);
        ArrayList names = new ArrayList();
        parser.accept(names::add);
        StringBuilder builder = new StringBuilder();
        int last = 0;
        for (TableNameParser.SqlToken name : names) {
            int start = name.getStart();
            if (start != last) {
                builder.append(sql, last, start);
                builder.append(this.schemaNameHandler.schemaHandler(itemDataSource, sql, name.getValue()));
            }
            last = name.getEnd();
        }
        if (last != sql.length()) {
            builder.append(sql.substring(last));
        }
        logger.debug("doSchemaService \u5904\u7406\u4e4b\u540esql=> {}", (Object)StringUtil.removeAllLineBreaks((CharSequence)builder.toString()));
        return builder.toString();
    }

    private SchemaDTO getSchemaDTO(MappedStatement ms) {
        DataSource dataSource = this.getDataSourceByMappedStatement(ms);
        ItemDataSource currentItemSource = MpUtils.getCurrentItemSource(dataSource);
        ExceptionUtils.throwMpe((null == currentItemSource ? 1 : 0) != 0, (String)"DatabaseSchemaInterceptor \u4e3a\u83b7\u53d6\u5230\u6570\u636e\u6e90\u7684\u76f8\u5173\u4fe1\u606f", (Object[])new Object[0]);
        return this.getSchemaDTO(currentItemSource, ms);
    }

    private SchemaDTO getSchemaDTO(StatementHandler statementHandler) {
        DataSource dataSource = this.getDataSourceByStatementHandler(statementHandler);
        ItemDataSource currentItemSource = MpUtils.getCurrentItemSource(dataSource);
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)statementHandler);
        MappedStatement ms = mpSh.mappedStatement();
        ExceptionUtils.throwMpe((null == currentItemSource ? 1 : 0) != 0, (String)"DatabaseSchemaInterceptor \u4e3a\u83b7\u53d6\u5230\u6570\u636e\u6e90\u7684\u76f8\u5173\u4fe1\u606f", (Object[])new Object[0]);
        return this.getSchemaDTO(currentItemSource, ms);
    }

    private SchemaDTO getSchemaDTO(ItemDataSource itemDataSource, MappedStatement ms) {
        SchemaDTO schemaDTO = new SchemaDTO();
        logger.debug("doSchemaService \u8fdb\u884c\u9a8c\u8bc1statement\u662f\u5426\u8fdb\u884c\u5904\u7406shema=> {}", (Object)ms.getId());
        boolean enableSchemaService = MpUtils.enbableSchemaService(ms.getId(), this.mybatisPlusPluginProperties);
        if (!enableSchemaService) {
            schemaDTO.setSchemaMybatisEnabled(enableSchemaService);
            return schemaDTO;
        }
        DbType dataSourceDbType = itemDataSource.getDbType();
        if (dataSourceDbType.getDb().equalsIgnoreCase(DbType.MYSQL.getDb())) {
            schemaDTO.setSchemaName("");
        } else {
            schemaDTO.setSchemaName(itemDataSource.getSchemaName());
        }
        schemaDTO.setItemDataSource(itemDataSource);
        if (dataSourceDbType.getDb().equalsIgnoreCase(DbType.SQL_SERVER.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.SQL_SERVER2005.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.MYSQL.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.OSCAR.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.ORACLE.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.ORACLE_12C.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.POSTGRE_SQL.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.KINGBASE_ES.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.DM.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.HIGH_GO.getDb()) || dataSourceDbType.getDb().equalsIgnoreCase(DbType.GAUSS.getDb())) {
            schemaDTO.setSchemaMybatisEnabled(Boolean.TRUE);
        } else {
            schemaDTO.setSchemaMybatisEnabled(Boolean.FALSE);
        }
        return schemaDTO;
    }

    private DataSource getDataSourceByStatementHandler(StatementHandler statementHandler) {
        PluginUtils.MPStatementHandler mpStatementHandler = PluginUtils.mpStatementHandler((StatementHandler)statementHandler);
        Configuration configuration = mpStatementHandler.configuration();
        return configuration.getEnvironment().getDataSource();
    }

    private DataSource getDataSourceByMappedStatement(MappedStatement ms) {
        return ms.getConfiguration().getEnvironment().getDataSource();
    }

    public DatabaseSchemaInterceptor(SchemaNameHandler schemaNameHandler) {
        this.schemaNameHandler = schemaNameHandler;
    }

    public DatabaseSchemaInterceptor(SchemaNameHandler schemaNameHandler, MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        this.schemaNameHandler = schemaNameHandler;
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
    }

    public SchemaNameHandler getSchemaNameHandler() {
        return this.schemaNameHandler;
    }

    public void setSchemaNameHandler(SchemaNameHandler schemaNameHandler) {
        this.schemaNameHandler = schemaNameHandler;
    }

    public MybatisPlusPluginProperties getMybatisPlusPluginProperties() {
        return this.mybatisPlusPluginProperties;
    }

    public void setMybatisPlusPluginProperties(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
    }
}

