/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.jxdinfo.hussar.platform.core.config.CoreConfiguration;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.IdStringCreator;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.config.MpMybatisPropertiesCustomizer;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusAutoFillProperties;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusPluginProperties;
import com.jxdinfo.hussar.support.mp.handler.DefaultHussarMetaObjectHandler;
import com.jxdinfo.hussar.support.mp.idgenerator.HussarIdGenerator;
import com.jxdinfo.hussar.support.mp.injector.HussarSqlInjector;
import com.jxdinfo.hussar.support.mp.intercept.QueryInterceptor;
import com.jxdinfo.hussar.support.mp.plugins.DatabaseSchemaInterceptor;
import com.jxdinfo.hussar.support.mp.plugins.HussarPaginationInterceptor;
import com.jxdinfo.hussar.support.mp.plugins.SqlLogInterceptor;
import com.jxdinfo.hussar.support.mp.plugins.support.schema.SchemaNameHandler;
import com.jxdinfo.hussar.support.mp.resolver.PageArgumentResolver;
import com.jxdinfo.hussar.support.mp.transaction.HussarMpTransactionFactory;
import com.jxdinfo.hussar.support.mp.translator.HussarMybatisExceptionTranslator;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import com.jxdinfo.hussar.support.sequence.config.HussarSequenceConfiguration;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CoreConfiguration.class, HussarSequenceConfiguration.class, MybatisPlusAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisPlusAutoFillProperties.class, MybatisPlusPluginProperties.class})
public class MpConfiguration
implements WebMvcConfigurer {
    private MybatisPlusPluginProperties mybatisPlusPluginProperties;
    private MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties;

    public MpConfiguration(MybatisPlusPluginProperties mybatisPlusPluginProperties, MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
        this.mybatisPlusAutoFillProperties = mybatisPlusAutoFillProperties;
    }

    public MpConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisPlusInterceptor.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor(ObjectProvider<QueryInterceptor[]> queryInterceptors, MybatisPlusPluginProperties mybatisPlusProperties, ObjectProvider<DatabaseSchemaInterceptor> databaseSchemaInterceptorObjectProvider) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        HussarPaginationInterceptor paginationInterceptor = new HussarPaginationInterceptor();
        Object[] queryInterceptorArray = (QueryInterceptor[])queryInterceptors.getIfAvailable();
        if (ObjectUtils.isNotEmpty((Object)queryInterceptorArray)) {
            AnnotationAwareOrderComparator.sort((Object[])queryInterceptorArray);
            paginationInterceptor.setQueryInterceptors((QueryInterceptor[])queryInterceptorArray);
        }
        paginationInterceptor.setMaxLimit(mybatisPlusProperties.getPageLimit());
        paginationInterceptor.setOverflow(mybatisPlusProperties.getOverflow());
        paginationInterceptor.setOptimizeJoin(mybatisPlusProperties.getOptimizeJoin());
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInterceptor);
        DatabaseSchemaInterceptor databaseSchemaInterceptor = (DatabaseSchemaInterceptor)databaseSchemaInterceptorObjectProvider.getIfAvailable();
        if (HussarUtils.isNotEmpty((Object)databaseSchemaInterceptor)) {
            interceptor.addInnerInterceptor((InnerInterceptor)databaseSchemaInterceptor);
        }
        return interceptor;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar.mp.plugin", name={"schemaEnabled"}, havingValue="true", matchIfMissing=true)
    public DatabaseSchemaInterceptor databaseSchemaInterceptor(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        SchemaNameHandler schemaNameHandler = (dataSource, sql, tableName) -> {
            StringBuilder stringBuilder = new StringBuilder();
            String[] tableNameArr = HussarUtils.splitTrim((String)tableName, (String)".");
            if (dataSource.getDbType().getDb().equalsIgnoreCase(DbType.MYSQL.getDb()) || tableNameArr.length > 1) {
                return tableName;
            }
            if (HussarUtils.isEmpty((Object)dataSource.getSchemaName())) {
                return tableName;
            }
            if (dataSource.getDbType().getDb().equalsIgnoreCase(DbType.SQL_SERVER.getDb()) || dataSource.getDbType().getDb().equalsIgnoreCase(DbType.SQL_SERVER2005.getDb())) {
                if (MpUtils.enableDoSqlserverPage(sql, tableName)) {
                    return tableName;
                }
                stringBuilder.append("[");
                stringBuilder.append(dataSource.getSchemaName());
                stringBuilder.append("]");
            } else {
                stringBuilder.append("\"");
                stringBuilder.append(dataSource.getSchemaName());
                stringBuilder.append("\"");
            }
            stringBuilder.append(".");
            stringBuilder.append(tableName);
            return stringBuilder.toString();
        };
        DatabaseSchemaInterceptor databaseSchemaInterceptor = new DatabaseSchemaInterceptor(schemaNameHandler, mybatisPlusPluginProperties);
        return databaseSchemaInterceptor;
    }

    @Bean
    public ConfigurationCustomizer mpMybatisPropertiesCustomizer() {
        return new MpMybatisPropertiesCustomizer();
    }

    @Bean
    public SqlLogInterceptor sqlLogInterceptor(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        return new SqlLogInterceptor(mybatisPlusPluginProperties);
    }

    @Bean
    public ISqlInjector sqlInjector() {
        return new HussarSqlInjector();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new PageArgumentResolver());
    }

    @Primary
    @Bean
    public IdentifierGenerator idGenerator(SeqBuilder seqBuilder) {
        Sequence sequence = seqBuilder.build();
        return new HussarIdGenerator(sequence);
    }

    @Bean
    public MetaObjectHandler metaObjectHandler(MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties, @Autowired(required=false) GetLoginUserService getLoginUserService, @Autowired(required=false) IdStringCreator idStringCreator) {
        return new DefaultHussarMetaObjectHandler(mybatisPlusAutoFillProperties, getLoginUserService, idStringCreator);
    }

    @Bean
    @ConditionalOnBean(name={"hussarTransactionAdvisor"})
    public TransactionFactory transactionFactory() {
        return new HussarMpTransactionFactory();
    }

    @Bean
    @Primary
    public SqlSessionTemplate hussarSqlSessionTemplate(SqlSessionFactory sqlSessionFactory, MybatisPlusProperties mybatisPlusProperties) {
        ExecutorType executorType = mybatisPlusProperties.getExecutorType();
        if (executorType == null) {
            executorType = sqlSessionFactory.getConfiguration().getDefaultExecutorType();
        }
        HussarMybatisExceptionTranslator persistenceExceptionTranslator = new HussarMybatisExceptionTranslator(sqlSessionFactory.getConfiguration().getEnvironment().getDataSource(), true);
        return new SqlSessionTemplate(sqlSessionFactory, executorType, (PersistenceExceptionTranslator)persistenceExceptionTranslator);
    }

    public MybatisPlusPluginProperties getMybatisPlusPluginProperties() {
        return this.mybatisPlusPluginProperties;
    }

    public void setMybatisPlusPluginProperties(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
    }

    public MybatisPlusAutoFillProperties getMybatisPlusAutoFillProperties() {
        return this.mybatisPlusAutoFillProperties;
    }

    public void setMybatisPlusAutoFillProperties(MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties) {
        this.mybatisPlusAutoFillProperties = mybatisPlusAutoFillProperties;
    }
}

