/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.utils;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ReflectUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.mp.base.query.annotations.QueryAlias;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusPluginProperties;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.AntPathMatcher;

public class MpUtils {
    public static String SQLSERVER2005_PAGE_TEMP_TABLE_NAME = "selectTemp";
    public static String SQLSERVER2005_PAGE_SQL_PREFIX = "WITH selectTemp AS (SELECT ";

    public static String idCreatorStr() {
        return String.valueOf(MpUtils.idCreator());
    }

    public static Long idCreator() {
        SeqBuilder seqBuilder = (SeqBuilder)SpringContextUtil.getBean(SeqBuilder.class);
        return seqBuilder.build().nextValue();
    }

    public static String getTableFieldName(Class<?> clazz, String name) {
        QueryAlias queryAlias = (QueryAlias)ReflectUtil.getAnnotation(clazz, (String)name, QueryAlias.class);
        if (HussarUtils.isNotEmpty((Object)queryAlias)) {
            return queryAlias.value();
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        if (HussarUtils.isEmpty((Object)tableInfo)) {
            return null;
        }
        if (name.equals(tableInfo.getKeyProperty())) {
            return tableInfo.getKeyColumn();
        }
        List tableFieldInfos = tableInfo.getFieldList();
        TableFieldInfo field = null;
        if (HussarUtils.isEmpty((Object)tableFieldInfos)) {
            return null;
        }
        List searchFields = tableFieldInfos.stream().filter(a -> a.getProperty().equals(name)).collect(Collectors.toList());
        if (HussarUtils.isEmpty(searchFields)) {
            return null;
        }
        field = (TableFieldInfo)searchFields.get(0);
        if (HussarUtils.isNotEmpty((Object)field)) {
            return field.getColumn();
        }
        return null;
    }

    public static ItemDataSource getCurrentItemSource(DataSource dataSource) {
        DynamicRoutingDataSource dynamicRoutingDataSource;
        DataSource determineDataSource;
        if (HussarUtils.isEmpty((Object)dataSource)) {
            return null;
        }
        if (dataSource instanceof TransactionAwareDataSourceProxy) {
            dataSource = ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource();
        }
        if (dataSource instanceof DynamicRoutingDataSource && (determineDataSource = (dynamicRoutingDataSource = (DynamicRoutingDataSource)dataSource).determineDataSource()) instanceof ItemDataSource) {
            return (ItemDataSource)determineDataSource;
        }
        return null;
    }

    public static boolean enableDoSqlserverPage(String sql, String tableName) {
        return StringUtil.startWith((CharSequence)sql, (CharSequence)SQLSERVER2005_PAGE_SQL_PREFIX) && StringUtil.equalsIgnoreCase((CharSequence)tableName, (CharSequence)SQLSERVER2005_PAGE_TEMP_TABLE_NAME);
    }

    public static boolean enbableSchemaService(String mappedId, MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        if (HussarUtils.isEmpty((Object)mybatisPlusPluginProperties) || HussarUtils.isEmpty((Object)mybatisPlusPluginProperties.getSchemaConfig()) || HussarUtils.isEmpty(mybatisPlusPluginProperties.getSchemaConfig().getExcludeSchemaMappers())) {
            return true;
        }
        List<String> excludeSchemaMappers = mybatisPlusPluginProperties.getSchemaConfig().getExcludeSchemaMappers();
        AntPathMatcher pathMatcher = new AntPathMatcher(".");
        boolean b = excludeSchemaMappers.stream().anyMatch(s -> pathMatcher.matchStart(s, mappedId));
        return !b;
    }
}

