/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.resolver;

import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageArgumentResolver
implements HandlerMethodArgumentResolver {
    private static Logger LOGGER = LoggerFactory.getLogger(PageArgumentResolver.class);
    private static final String[] KEYWORDS = new String[]{"master", "truncate", "insert", "select", "delete", "update", "declare", "alter", "drop", "sleep"};

    public boolean supportsParameter(MethodParameter parameter) {
        return Page.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(@NonNull MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) {
        String pageParam = request.getParameter("current");
        String sizeParam = request.getParameter("size");
        String[] ascs = request.getParameterValues("ascs");
        String[] descs = request.getParameterValues("descs");
        Page page = new Page();
        if (StringUtils.isNotBlank((CharSequence)pageParam)) {
            page.setCurrent(Long.parseLong(pageParam));
        }
        if (StringUtils.isNotBlank((CharSequence)sizeParam)) {
            page.setSize(Long.parseLong(sizeParam));
        }
        ArrayList orderItemList = new ArrayList();
        Optional.ofNullable(ascs).ifPresent(s -> orderItemList.addAll(Arrays.stream(s).filter(this.sqlInjectPredicate()).map(OrderItem::asc).collect(Collectors.toList())));
        Optional.ofNullable(descs).ifPresent(s -> orderItemList.addAll(Arrays.stream(s).filter(this.sqlInjectPredicate()).map(OrderItem::desc).collect(Collectors.toList())));
        page.addOrder(orderItemList);
        return page;
    }

    private Predicate<String> sqlInjectPredicate() {
        return sql -> {
            for (String keyword : KEYWORDS) {
                if (!StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)keyword)) continue;
                return false;
            }
            return true;
        };
    }
}

