/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.translator;

import com.jxdinfo.hussar.platform.core.utils.datasource.DataSourceUtil;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.ibatis.exceptions.PersistenceException;
import org.mybatis.spring.MyBatisSystemException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.transaction.TransactionException;

public class HussarMybatisExceptionTranslator
implements PersistenceExceptionTranslator {
    private final Supplier<SQLExceptionTranslator> exceptionTranslatorSupplier;
    private final Map<DataSource, SQLExceptionTranslator> exceptionTranslator = new HashMap<DataSource, SQLExceptionTranslator>();
    private final DataSource dataSource;

    public HussarMybatisExceptionTranslator(DataSource dataSource, boolean exceptionTranslatorLazyInit) {
        this(() -> new SQLErrorCodeSQLExceptionTranslator(DataSourceUtil.getRealDataSource((DataSource)dataSource)), dataSource, exceptionTranslatorLazyInit);
    }

    public HussarMybatisExceptionTranslator(Supplier<SQLExceptionTranslator> exceptionTranslatorSupplier, DataSource dataSource, boolean exceptionTranslatorLazyInit) {
        this.exceptionTranslatorSupplier = exceptionTranslatorSupplier;
        this.dataSource = dataSource;
        if (!exceptionTranslatorLazyInit) {
            this.initExceptionTranslator();
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException e) {
        if (e instanceof PersistenceException) {
            if (e.getCause() instanceof PersistenceException) {
                e = (PersistenceException)e.getCause();
            }
            if (e.getCause() instanceof SQLException) {
                SQLExceptionTranslator exceptionTranslator = this.initExceptionTranslator();
                return exceptionTranslator.translate(e.getMessage() + "\n", null, (SQLException)e.getCause());
            }
            if (e.getCause() instanceof TransactionException) {
                throw (TransactionException)e.getCause();
            }
            return new MyBatisSystemException((Throwable)e);
        }
        return null;
    }

    private synchronized SQLExceptionTranslator initExceptionTranslator() {
        DataSource realDataSource = DataSourceUtil.getRealDataSource((DataSource)this.dataSource);
        SQLExceptionTranslator sqlExceptionTranslator = this.exceptionTranslator.get(realDataSource);
        if (sqlExceptionTranslator != null) {
            return sqlExceptionTranslator;
        }
        sqlExceptionTranslator = this.exceptionTranslatorSupplier.get();
        this.exceptionTranslator.put(realDataSource, sqlExceptionTranslator);
        return sqlExceptionTranslator;
    }
}

