/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.base.query.strategy;

import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.query.dto.FieldMappingDto;
import com.jxdinfo.hussar.support.mp.base.query.strategy.QueryStrategy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class MultiQueryStrategy
implements QueryStrategy {
    @Override
    public FieldMappingDto transFieldValue(FieldMappingDto fieldMappingDto) {
        Object fieldValue = fieldMappingDto.getFieldValue();
        if (HussarUtils.isEmpty((Object)fieldValue)) {
            return fieldMappingDto;
        }
        List<Object> values = new ArrayList();
        if (fieldValue instanceof Collection) {
            for (Object obj : (Collection)fieldValue) {
                values.add(obj.toString());
            }
        } else {
            String value = fieldValue.toString();
            values = Arrays.asList(value.split(","));
        }
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        switch (fieldMappingDto.getFieldClassType().toString()) {
            case "class java.lang.Integer": {
                for (String string : values) {
                    fieldValues.add(Integer.parseInt(string));
                }
                break;
            }
            case "class java.lang.Short": {
                for (String string : values) {
                    fieldValues.add(Short.parseShort(string));
                }
                break;
            }
            case "class java.lang.Long": {
                for (String string : values) {
                    fieldValues.add(Long.parseLong(string));
                }
                break;
            }
            case "class java.lang.Float": {
                for (String string : values) {
                    fieldValues.add(Float.valueOf(Float.parseFloat(string)));
                }
                break;
            }
            case "class java.lang.Double": {
                for (String string : values) {
                    fieldValues.add(Double.parseDouble(string));
                }
                break;
            }
            case "class java.math.BigDecimal": {
                for (String string : values) {
                    fieldValues.add(new BigDecimal(string));
                }
                break;
            }
            case "class java.time.LocalDate": {
                for (String string : values) {
                    fieldValues.add(DateTimeUtil.parseDate((String)string));
                }
                break;
            }
            case "class java.time.LocalDateTime": {
                for (String string : values) {
                    fieldValues.add(DateTimeUtil.parseDateTime((String)string));
                }
                break;
            }
            case "class java.time.LocalTime": {
                for (String string : values) {
                    fieldValues.add(DateTimeUtil.parseTime((String)string));
                }
                break;
            }
            case "class java.lang.Boolean": {
                for (String string : values) {
                    fieldValues.add(Boolean.valueOf(string));
                }
            }
            default: {
                fieldValues.addAll(values);
            }
        }
        fieldMappingDto.setFieldValues(fieldValues);
        return fieldMappingDto;
    }
}

