/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.base.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.mapper.HussarMapper;
import com.jxdinfo.hussar.support.mp.base.service.HussarService;
import com.jxdinfo.hussar.support.mp.injector.HussarSqlMethod;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.springframework.transaction.annotation.Transactional;

public class HussarServiceImpl<M extends HussarMapper<T>, T extends BaseEntity>
extends ServiceImpl<M, T>
implements HussarService<T> {
    @Transactional(rollbackFor={Exception.class})
    public boolean save(T entity) {
        return SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).insert(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeById(Serializable id) {
        return SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).deleteById(id));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeById(T entity) {
        return SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).deleteById(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeByMap(Map<String, Object> columnMap) {
        Assert.notEmpty(columnMap, (String)"error: columnMap must not be empty", (Object[])new Object[0]);
        return SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).deleteByMap(columnMap));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean remove(Wrapper<T> queryWrapper) {
        return SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).delete(queryWrapper));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        return CollectionUtils.isEmpty(idList) ? false : SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).deleteBatchIds(idList));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(T entity) {
        return SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).updateById(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean update(Wrapper<T> updateWrapper) {
        return this.update((T)null, updateWrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean update(T entity, Wrapper<T> updateWrapper) {
        return SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).update(entity, updateWrapper));
    }

    @Override
    public boolean saveIgnore(T entity) {
        return SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).insertIgnore(entity));
    }

    @Override
    public boolean saveReplace(T entity) {
        return SqlHelper.retBool((Integer)((HussarMapper)this.baseMapper).replace(entity));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveIgnoreBatch(Collection<T> entityList, int batchSize) {
        return this.saveBatch(entityList, batchSize, HussarSqlMethod.INSERT_IGNORE_ONE);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveReplaceBatch(Collection<T> entityList, int batchSize) {
        return this.saveBatch(entityList, batchSize, HussarSqlMethod.REPLACE_ONE);
    }

    private boolean saveBatch(Collection<T> entityList, int batchSize, HussarSqlMethod sqlMethod) {
        String sqlStatement = this.hussarSqlStatement(sqlMethod);
        this.executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
        return true;
    }

    protected String hussarSqlStatement(HussarSqlMethod sqlMethod) {
        return SqlHelper.table((Class)this.currentModelClass()).getSqlStatement(sqlMethod.getMethod());
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.INSERT_ONE);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Override
    public boolean saveBatchNoTransaction(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.INSERT_ONE);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdate(T entity) {
        if (null != entity) {
            TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)this.entityClass);
            Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
            String keyProperty = tableInfo.getKeyProperty();
            Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
            Object idVal = tableInfo.getPropertyValue(entity, tableInfo.getKeyProperty());
            return StringUtils.checkValNull((Object)idVal) || Objects.isNull(this.getById((Serializable)idVal)) ? this.save(entity) : this.updateById(entity);
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)this.entityClass);
        Assert.notNull((Object)tableInfo, (String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        return SqlHelper.saveOrUpdateBatch((Class)this.entityClass, (Class)this.mapperClass, (Log)this.log, entityList, (int)batchSize, (sqlSession, entity) -> {
            Object idVal = tableInfo.getPropertyValue(entity, keyProperty);
            return StringUtils.checkValNull((Object)idVal) || CollectionUtils.isEmpty((Collection)sqlSession.selectList(this.getSqlStatement(SqlMethod.SELECT_BY_ID), entity));
        }, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(this.getSqlStatement(SqlMethod.UPDATE_BY_ID), (Object)param);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateBatchById(Collection<T> entityList, int batchSize) {
        String sqlStatement = this.getSqlStatement(SqlMethod.UPDATE_BY_ID);
        return this.executeBatch(entityList, batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }
}

