/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.base.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Charsets;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.WebUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionDto;
import com.jxdinfo.hussar.support.mp.base.query.dto.SuperQueryConditionPage;
import com.jxdinfo.hussar.support.mp.base.query.generator.SingleTableQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.query.generator.superquery.SuperQueryGenerator;
import com.jxdinfo.hussar.support.mp.base.service.HussarService;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriUtils;

public class HussarBaseController<T extends BaseEntity, S extends HussarService<T>> {
    @Autowired
    public S hussarService;
    @Autowired
    private HttpServletRequest request;
    protected Class<T> entityClass = this.currentModelClass();

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @GetMapping(value={"/listPage"})
    public ApiResponse<IPage<T>> listPage(T t, Page<T> page, HttpServletRequest req) {
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper<T> queryWrapper = singleTableQueryGenerator.initQueryWrapper(t, req.getParameterMap());
        IPage pageList = this.hussarService.page(page, queryWrapper);
        return ApiResponse.success((Object)pageList);
    }

    @GetMapping(value={"/list"})
    public ApiResponse<List<T>> list(T t, HttpServletRequest req) {
        SingleTableQueryGenerator singleTableQueryGenerator = new SingleTableQueryGenerator();
        QueryWrapper<T> queryWrapper = singleTableQueryGenerator.initQueryWrapper(t, req.getParameterMap());
        List list = this.hussarService.list(queryWrapper);
        return ApiResponse.success((Object)list);
    }

    @PostMapping(value={"/superList"})
    public ApiResponse<List<T>> superList(@RequestBody List<SuperQueryConditionDto> superQueryConditionDtoList) {
        QueryWrapper queryWrapper = Wrappers.query();
        SuperQueryGenerator<T> superQueryGenerator = new SuperQueryGenerator<T>(this.entityClass);
        superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
        List list = this.hussarService.list((Wrapper)queryWrapper);
        return ApiResponse.success((Object)list);
    }

    @PostMapping(value={"/superListPage"})
    public ApiResponse<Page<T>> superListPage(@RequestBody SuperQueryConditionPage superQueryConditionDtoPage) {
        QueryWrapper queryWrapper = Wrappers.query();
        if (HussarUtils.isEmpty((Object)superQueryConditionDtoPage)) {
            Page page = new Page();
            Page pageList = (Page)this.hussarService.page((IPage)page, (Wrapper)queryWrapper);
            return ApiResponse.success((Object)pageList);
        }
        Page page = superQueryConditionDtoPage.getPage();
        List<SuperQueryConditionDto> superQueryConditionDtoList = superQueryConditionDtoPage.getSuperQueryConditionDtoList();
        SuperQueryGenerator<T> superQueryGenerator = new SuperQueryGenerator<T>(this.entityClass);
        superQueryGenerator.initSuperQueryWrapper(queryWrapper, superQueryConditionDtoList);
        Page pageList = (Page)this.hussarService.page((IPage)page, (Wrapper)queryWrapper);
        return ApiResponse.success((Object)pageList);
    }

    @GetMapping(value={"/listById"})
    public ApiResponse<T> listById(@RequestParam(name="id") String id) {
        BaseEntity newT = (BaseEntity)this.hussarService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)newT)) {
            throw new HussarException("\u672a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return ApiResponse.success((Object)newT);
    }

    @GetMapping(value={"/listByIds"})
    public ApiResponse<List<T>> listByIds(@RequestParam String ids) {
        String[] id = ids.split(",");
        List<String> idList = Arrays.asList(id);
        List dataList = this.hussarService.listByIds(idList);
        if (HussarUtils.isEmpty((Object)dataList)) {
            throw new HussarException("\u4e3a\u67e5\u8be2\u5230\u6570\u636e");
        }
        return ApiResponse.success((Object)dataList);
    }

    @GetMapping(value={"/deleteById"})
    public ApiResponse<T> deleteById(@RequestParam(name="id") String id) {
        try {
            boolean ok = this.hussarService.removeById((Serializable)((Object)id));
            if (ok) {
                return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
            }
            throw new HussarException("\u5220\u9664\u5931\u8d25\uff0c\u662f\u5426\u5b58\u5728\u6b64\u6570\u636e");
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", e.getCause());
        }
    }

    @GetMapping(value={"/deleteBatchByIds"})
    public ApiResponse<T> deleteBatchByIds(@RequestParam(name="ids") String ids) {
        if (HussarUtils.isEmpty((Object)ids)) {
            throw new HussarException("\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        try {
            this.hussarService.removeByIds(Arrays.asList(ids.split(",")));
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            throw new HussarException("\u5220\u9664\u5931\u8d25", e.getCause());
        }
    }

    @PostMapping(value={"/save"})
    public ApiResponse<T> save(@RequestBody T t) {
        try {
            this.hussarService.save(t);
            return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception exception) {
            throw new HussarException(exception.getMessage(), exception.getCause());
        }
    }

    protected ResponseEntity<ResourceRegion> download(File file, String fileName) throws IOException {
        FileSystemResource resource = new FileSystemResource(file);
        return this.download((Resource)resource, fileName);
    }

    protected ResponseEntity<ResourceRegion> download(Resource resource, String fileName) throws IOException {
        HttpServletRequest request = WebUtil.getRequest();
        String header = request.getHeader("User-Agent");
        header = header == null ? "" : header.toUpperCase();
        String msie = "MSIE";
        String trident = "TRIDENT";
        String edge = "EDGE";
        HttpStatus status = header.contains(msie) || header.contains(trident) || header.contains(edge) ? HttpStatus.OK : HttpStatus.CREATED;
        long position = 0L;
        long count = resource.contentLength();
        String range = request.getHeader("Range");
        if (null != range) {
            status = HttpStatus.PARTIAL_CONTENT;
            String[] rangeRange = range.replace("bytes=", "").split("-");
            position = Long.parseLong(rangeRange[0]);
            if (rangeRange.length > 1) {
                long end = Long.parseLong(rangeRange[1]);
                count = end - position + 1L;
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        String encodeFileName = UriUtils.encode((String)fileName, (Charset)Charsets.UTF_8);
        String disposition = "attachment;filename=\"" + encodeFileName + "\";filename*=utf-8''" + encodeFileName;
        headers.set("Content-Disposition", disposition);
        return new ResponseEntity((Object)new ResourceRegion(resource, position, count), (MultiValueMap)headers, status);
    }

    protected Class<T> currentModelClass() {
        return ReflectionKit.getSuperClassGenericType(this.getClass(), HussarBaseController.class, (int)0);
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }
}

