/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.database.adapter;

import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ObjectDateTypeHandler
extends BaseTypeHandler<Object> {
    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Object o, JdbcType jdbcType) throws SQLException {
        LocalDate localDate;
        try {
            LocalDateTime localDateTime = DateTimeUtil.parseDateTime((String)o.toString());
            localDate = localDateTime.toLocalDate();
        }
        catch (DateTimeParseException e) {
            localDate = DateTimeUtil.parseDate((String)o.toString());
        }
        preparedStatement.setObject(i, localDate);
    }

    public Object getNullableResult(ResultSet resultSet, String s) throws SQLException {
        Date date = resultSet.getDate(s);
        return this.dateToLocalDateTime(date);
    }

    public Object getNullableResult(ResultSet resultSet, int i) throws SQLException {
        Date date = resultSet.getDate(i);
        return this.dateToLocalDateTime(date);
    }

    public Object getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        Date date = callableStatement.getDate(i);
        return this.dateToLocalDateTime(date);
    }

    private LocalDateTime dateToLocalDateTime(Date date) {
        if (HussarUtils.isEmpty((Object)date)) {
            return null;
        }
        return date.toLocalDate().atStartOfDay();
    }
}

