/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.config;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.jxdinfo.hussar.platform.core.config.CoreConfiguration;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.sequence.seq.Sequence;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.IdStringCreator;
import com.jxdinfo.hussar.support.mp.config.MpMybatisPropertiesCustomizer;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusAutoFillProperties;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusPluginProperties;
import com.jxdinfo.hussar.support.mp.handler.DefaultHussarMetaObjectHandler;
import com.jxdinfo.hussar.support.mp.idgenerator.HussarIdGenerator;
import com.jxdinfo.hussar.support.mp.injector.HussarSqlInjector;
import com.jxdinfo.hussar.support.mp.intercept.QueryInterceptor;
import com.jxdinfo.hussar.support.mp.plugins.HussarPaginationInterceptor;
import com.jxdinfo.hussar.support.mp.plugins.SqlLogInterceptor;
import com.jxdinfo.hussar.support.mp.resolver.PageArgumentResolver;
import com.jxdinfo.hussar.support.mp.transaction.HussarMpTransactionFactory;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.ibatis.transaction.TransactionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CoreConfiguration.class, MybatisPlusAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisPlusAutoFillProperties.class, MybatisPlusPluginProperties.class})
public class MpConfiguration
implements WebMvcConfigurer {
    private MybatisPlusPluginProperties mybatisPlusPluginProperties;
    private MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties;

    public MpConfiguration(MybatisPlusPluginProperties mybatisPlusPluginProperties, MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
        this.mybatisPlusAutoFillProperties = mybatisPlusAutoFillProperties;
    }

    public MpConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisPlusInterceptor.class})
    public MybatisPlusInterceptor mybatisPlusInterceptor(ObjectProvider<QueryInterceptor[]> queryInterceptors, MybatisPlusPluginProperties mybatisPlusProperties) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        HussarPaginationInterceptor paginationInterceptor = new HussarPaginationInterceptor();
        Object[] queryInterceptorArray = (QueryInterceptor[])queryInterceptors.getIfAvailable();
        if (ObjectUtils.isNotEmpty((Object)queryInterceptorArray)) {
            AnnotationAwareOrderComparator.sort((Object[])queryInterceptorArray);
            paginationInterceptor.setQueryInterceptors((QueryInterceptor[])queryInterceptorArray);
        }
        paginationInterceptor.setMaxLimit(mybatisPlusProperties.getPageLimit());
        paginationInterceptor.setOverflow(mybatisPlusProperties.getOverflow());
        paginationInterceptor.setOptimizeJoin(mybatisPlusProperties.getOptimizeJoin());
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInterceptor);
        return interceptor;
    }

    @Bean
    public ConfigurationCustomizer mpMybatisPropertiesCustomizer() {
        return new MpMybatisPropertiesCustomizer();
    }

    @Bean
    public SqlLogInterceptor sqlLogInterceptor(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        return new SqlLogInterceptor(mybatisPlusPluginProperties);
    }

    @Bean
    public ISqlInjector sqlInjector() {
        return new HussarSqlInjector();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(new PageArgumentResolver());
    }

    @Primary
    @Bean
    public IdentifierGenerator idGenerator(SeqBuilder seqBuilder) {
        Sequence sequence = seqBuilder.build();
        return new HussarIdGenerator(sequence);
    }

    @Bean
    public MetaObjectHandler metaObjectHandler(MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties, @Autowired(required=false) GetLoginUserService getLoginUserService, @Autowired(required=false) IdStringCreator idStringCreator) {
        return new DefaultHussarMetaObjectHandler(mybatisPlusAutoFillProperties, getLoginUserService, idStringCreator);
    }

    @Bean
    @ConditionalOnBean(name={"hussarTransactionAdvisor"})
    @ConditionalOnMissingBean(name={"hussarSeataTransactionScanner"})
    public TransactionFactory transactionFactory() {
        return new HussarMpTransactionFactory();
    }

    public MybatisPlusPluginProperties getMybatisPlusPluginProperties() {
        return this.mybatisPlusPluginProperties;
    }

    public void setMybatisPlusPluginProperties(MybatisPlusPluginProperties mybatisPlusPluginProperties) {
        this.mybatisPlusPluginProperties = mybatisPlusPluginProperties;
    }

    public MybatisPlusAutoFillProperties getMybatisPlusAutoFillProperties() {
        return this.mybatisPlusAutoFillProperties;
    }

    public void setMybatisPlusAutoFillProperties(MybatisPlusAutoFillProperties mybatisPlusAutoFillProperties) {
        this.mybatisPlusAutoFillProperties = mybatisPlusAutoFillProperties;
    }
}

