/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.utils;

import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.List;
import java.util.regex.Pattern;

public class SqlEscapeUtil {
    private static final Pattern SPECIAL_WORD_PATTERN = Pattern.compile("[%_]", 2);
    private static final List<Character> symbols = CollectionUtil.ofImmutableList((Object[])new Character[]{Character.valueOf('%'), Character.valueOf('_')});
    public static final Character ESCAPE_SYMBOL = Character.valueOf('|');

    public static boolean needEscape(String value) {
        if (SPECIAL_WORD_PATTERN.matcher(value).find()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String handleParameter(String value) {
        StringBuilder sb = new StringBuilder();
        Character pre = Character.valueOf(' ');
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character cur = Character.valueOf(cArray[i]);
            if (symbols.contains(cur) && pre != ESCAPE_SYMBOL) {
                sb.append(ESCAPE_SYMBOL);
            }
            pre = cur;
            sb.append(cur);
        }
        return sb.toString();
    }
}

