/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.handler;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.jxdinfo.hussar.platform.core.constants.CoreConstants;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.IdStringCreator;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusAutoFillProperties;
import com.jxdinfo.hussar.support.mp.handler.AbstractHussarMetaObjectHandler;
import com.jxdinfo.hussar.support.mp.handler.FieldFillDto;
import com.jxdinfo.hussar.support.mp.handler.annotations.HussarIdFill;
import com.jxdinfo.hussar.support.mp.utils.MpUtils;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHussarMetaObjectHandler
extends AbstractHussarMetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultHussarMetaObjectHandler.class);
    private IdStringCreator idStringCreator;

    public DefaultHussarMetaObjectHandler(MybatisPlusAutoFillProperties autoFillProperties) {
        super(autoFillProperties);
    }

    public DefaultHussarMetaObjectHandler(MybatisPlusAutoFillProperties autoFillProperties, GetLoginUserService getLoginUserService) {
        super(autoFillProperties, getLoginUserService);
    }

    public DefaultHussarMetaObjectHandler(MybatisPlusAutoFillProperties autoFillProperties, GetLoginUserService getLoginUserService, IdStringCreator idStringCreator) {
        super(autoFillProperties, getLoginUserService);
        this.idStringCreator = idStringCreator;
    }

    @Override
    public void customInsertFill(MetaObject metaObject) {
        this.autoFillCreate(metaObject);
        this.autoFillUpdate(metaObject, FieldFill.INSERT);
        this.autoFillDel(metaObject);
        this.autoFillIdStr(metaObject);
    }

    @Override
    public void customUpdatetFill(MetaObject metaObject) {
        this.autoFillUpdate(metaObject, FieldFill.UPDATE);
    }

    private void autoFillCreate(MetaObject metaObject) {
        String creatorStrField;
        String creatorField;
        String createTimeField;
        Long userId = this.getUserId();
        List<FieldFillDto> fillDtoList = this.getFillList(metaObject.getOriginalObject().getClass(), FieldFill.INSERT);
        if (this.isNeedFill(fillDtoList, createTimeField = this.autoFillProperties.getCreateTimeField())) {
            this.strictInsertFill(metaObject, this.autoFillProperties.getCreateTimeField(), LocalDateTime.class, LocalDateTime.now());
        }
        if (this.isNeedFill(fillDtoList, creatorField = this.autoFillProperties.getCreatorField())) {
            this.strictInsertFill(metaObject, this.autoFillProperties.getCreatorField(), Long.class, userId);
        }
        if (this.isNeedFill(fillDtoList, creatorStrField = this.autoFillProperties.getCreatorStrField())) {
            this.strictInsertFill(metaObject, this.autoFillProperties.getCreatorStrField(), String.class, this.getUserCodeStr());
        }
    }

    private void autoFillUpdate(MetaObject metaObject, FieldFill fieldFill) {
        String lastEditorStrField;
        String lastEditorField;
        String lastUpdateTimeField;
        Long userId = this.getUserId();
        List<FieldFillDto> fillDtoList = this.getFillList(metaObject.getOriginalObject().getClass(), fieldFill);
        if (this.isNeedFill(fillDtoList, lastUpdateTimeField = this.autoFillProperties.getLastUpdateTime())) {
            this.setFieldValByName(lastUpdateTimeField, LocalDateTime.now(), metaObject);
        }
        if (this.isNeedFill(fillDtoList, lastEditorField = this.autoFillProperties.getLastEditorField())) {
            this.setFieldValByName(lastEditorField, userId, metaObject);
        }
        if (this.isNeedFill(fillDtoList, lastEditorStrField = this.autoFillProperties.getLastEditorFieldStrField())) {
            this.setFieldValByName(lastEditorStrField, this.getUserCodeStr(), metaObject);
        }
    }

    private void autoFillDel(MetaObject metaObject) {
        this.strictInsertFill(metaObject, this.autoFillProperties.getDelFlagField(), String.class, "0");
    }

    private void autoFillIdStr(MetaObject metaObject) {
        List<Field> idStrField = this.findIdStrField(metaObject);
        idStrField.forEach(field -> {
            Object idStr = this.getFieldValByName(field.getName(), metaObject);
            if (HussarUtils.isEmpty((Object)idStr)) {
                idStr = this.getIdStr();
                this.setFieldValByName(field.getName(), idStr, metaObject);
            }
        });
    }

    private List<Field> findIdStrField(MetaObject metaObject) {
        List allFields = TableInfoHelper.getAllFields(metaObject.getOriginalObject().getClass());
        List<Field> idFieldFillList = allFields.stream().filter(field -> {
            if (field.isAnnotationPresent(HussarIdFill.class)) {
                TableField annotation = field.getAnnotation(TableField.class);
                return annotation.fill().equals((Object)FieldFill.INSERT) && !this.validDefaultFiled((Field)field);
            }
            return false;
        }).collect(Collectors.toList());
        return idFieldFillList;
    }

    private Long getUserId() {
        Long userId = CoreConstants.USER_ID_NULL;
        if (HussarUtils.isEmpty((Object)this.getLoginUserService)) {
            return userId;
        }
        UserDetails userDetails = this.getLoginUserService.getCurrentUserDetail();
        if (HussarUtils.isEmpty((Object)userDetails)) {
            return userId;
        }
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            userId = userDetails.getUserId();
        }
        return userId;
    }

    private String getUserCodeStr() {
        String userId = "0";
        if (HussarUtils.isEmpty((Object)this.getLoginUserService)) {
            return userId;
        }
        UserDetails userDetails = this.getLoginUserService.getCurrentUserDetail();
        if (HussarUtils.isEmpty((Object)userDetails)) {
            return userId;
        }
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            userId = userDetails.getUserIdStr();
        }
        return userId;
    }

    private String getIdStr() {
        if (HussarUtils.isEmpty((Object)this.idStringCreator)) {
            return MpUtils.idCreatorStr();
        }
        return this.idStringCreator.createIdStr();
    }

    private List<FieldFillDto> getFillList(Class<?> clazz, FieldFill fieldFill) {
        Map fillListMap = (Map)cacheFillField.get(clazz);
        if (HussarUtils.isEmpty((Object)fillListMap)) {
            return new ArrayList<FieldFillDto>();
        }
        return (List)fillListMap.get(fieldFill);
    }

    private boolean isNeedFill(List<FieldFillDto> fieldFillDtoList, String fieldName) {
        if (HussarUtils.isEmpty(fieldFillDtoList)) {
            return true;
        }
        Optional<FieldFillDto> fieldFillDto = fieldFillDtoList.stream().filter(f -> f.getPropertyName().equals(fieldName)).findAny();
        return !fieldFillDto.isPresent();
    }
}

