/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.database.adapter;

import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ObjectDateTypeHandler
extends BaseTypeHandler<Object> {
    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Object o, JdbcType jdbcType) throws SQLException {
        LocalDate localDate;
        try {
            LocalDateTime localDateTime = DateTimeUtil.parseDateTime((String)o.toString());
            localDate = localDateTime.toLocalDate();
        }
        catch (DateTimeParseException e) {
            localDate = DateTimeUtil.parseDate((String)o.toString());
        }
        preparedStatement.setObject(i, localDate);
    }

    public Object getNullableResult(ResultSet resultSet, String s) throws SQLException {
        LocalDate localDate = resultSet.getObject(s, LocalDate.class);
        return this.localDateToLocalDateTime(localDate);
    }

    public Object getNullableResult(ResultSet resultSet, int i) throws SQLException {
        LocalDate localDate = resultSet.getObject(i, LocalDate.class);
        return this.localDateToLocalDateTime(localDate);
    }

    public Object getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        LocalDate localDate = callableStatement.getObject(i, LocalDate.class);
        return this.localDateToLocalDateTime(localDate);
    }

    private LocalDateTime localDateToLocalDateTime(LocalDate localDate) {
        if (HussarUtils.isEmpty((Object)localDate)) {
            return null;
        }
        return localDate.atStartOfDay();
    }
}

