/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.config;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.database.adapter.BigDecimalNumericTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.LocalDateTimeDateTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.LocalDateTimeToTimestampTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.LocalDateToDateTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.LocalTimeToTimeTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectBitTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectBlobTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectClobTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectDateTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectTimeStampTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectTimeTypeHandler;
import com.jxdinfo.hussar.support.mp.log.Log4j2Impl;
import com.jxdinfo.hussar.support.mp.log.NoLoggingImpl;
import com.jxdinfo.hussar.support.mp.typeconvter.JsonStringArrayTypeHandler;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class MpMybatisPropertiesCustomizer
implements ConfigurationCustomizer {
    public void customize(MybatisConfiguration configuration) {
        Class logImpl = configuration.getLogImpl();
        if (HussarUtils.isEmpty((Object)logImpl)) {
            configuration.setLogImpl(NoLoggingImpl.class);
        } else if (!HussarUtils.equals(StdOutImpl.class, (Object)logImpl)) {
            configuration.setLogImpl(Log4j2Impl.class);
        }
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (HussarUtils.isNotEmpty((Object)typeHandlerRegistry)) {
            typeHandlerRegistry.register(JsonStringArrayTypeHandler.class.getPackage().getName());
            typeHandlerRegistry.register(Object.class, JdbcType.CLOB, (TypeHandler)new ObjectClobTypeHandler());
            typeHandlerRegistry.register(Object.class, JdbcType.BLOB, (TypeHandler)new ObjectBlobTypeHandler());
            typeHandlerRegistry.register(Object.class, JdbcType.BIT, (TypeHandler)new ObjectBitTypeHandler());
            typeHandlerRegistry.register(BigDecimal.class, JdbcType.NUMERIC, (TypeHandler)new BigDecimalNumericTypeHandler());
            typeHandlerRegistry.register(LocalDateTime.class, JdbcType.DATE, (TypeHandler)new LocalDateTimeDateTypeHandler());
            typeHandlerRegistry.register(LocalDate.class, JdbcType.DATE, (TypeHandler)new LocalDateToDateTypeHandler());
            typeHandlerRegistry.register(Object.class, JdbcType.DATE, (TypeHandler)new ObjectDateTypeHandler());
            typeHandlerRegistry.register(LocalTime.class, JdbcType.TIME, (TypeHandler)new LocalTimeToTimeTypeHandler());
            typeHandlerRegistry.register(Object.class, JdbcType.TIME, (TypeHandler)new ObjectTimeTypeHandler());
            typeHandlerRegistry.register(LocalDateTime.class, JdbcType.TIMESTAMP, (TypeHandler)new LocalDateTimeToTimestampTypeHandler());
            typeHandlerRegistry.register(Object.class, JdbcType.TIMESTAMP, (TypeHandler)new ObjectTimeStampTypeHandler());
        }
    }
}

