/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.handler;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.jxdinfo.hussar.platform.core.constants.CoreConstants;
import com.jxdinfo.hussar.platform.core.support.service.GetLoginUserService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.config.MybatisPlusAutoFillProperties;
import java.time.LocalDateTime;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;

public class HussarMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(HussarMetaObjectHandler.class);
    private MybatisPlusAutoFillProperties autoFillProperties;
    @Autowired
    private GetLoginUserService getLoginUserService;

    public HussarMetaObjectHandler(MybatisPlusAutoFillProperties autoFillProperties) {
        this.autoFillProperties = autoFillProperties;
    }

    public boolean openInsertFill() {
        return this.autoFillProperties.getEnabled() != false || this.autoFillProperties.getEnableInsertFill() != false;
    }

    public boolean openUpdateFill() {
        return this.autoFillProperties.getEnabled() != false || this.autoFillProperties.getEnableUpdateFill() != false;
    }

    public void insertFill(MetaObject metaObject) {
        this.autoFillCreate(metaObject);
        this.autoFillUpdate(metaObject);
        this.autoFillDel(metaObject);
    }

    public void updateFill(MetaObject metaObject) {
        this.autoFillUpdate(metaObject);
    }

    private void autoFillCreate(MetaObject metaObject) {
        Long userId = this.getUserId();
        Object createTime = this.getFieldValByName(this.autoFillProperties.getCreateTimeField(), metaObject);
        Object creator = this.getFieldValByName(this.autoFillProperties.getCreatorField(), metaObject);
        if (ObjectUtils.isEmpty((Object)createTime)) {
            LocalDateTime now = LocalDateTime.now();
            this.setFieldValByName(this.autoFillProperties.getCreateTimeField(), now, metaObject);
        }
        if (this.pkIsNull(creator)) {
            this.setFieldValByName(this.autoFillProperties.getCreatorField(), userId, metaObject);
        }
    }

    private void autoFillUpdate(MetaObject metaObject) {
        Long userId = this.getUserId();
        Object lastUpdateor = this.getFieldValByName(this.autoFillProperties.getLastEditorField(), metaObject);
        if (this.pkIsNull(lastUpdateor)) {
            this.setFieldValByName(this.autoFillProperties.getLastEditorField(), userId, metaObject);
        }
        LocalDateTime now = LocalDateTime.now();
        this.setFieldValByName(this.autoFillProperties.getLastUpdateTime(), now, metaObject);
    }

    private void autoFillDel(MetaObject metaObject) {
        Object delFlag = this.getFieldValByName(this.autoFillProperties.getDelFlagField(), metaObject);
        if (ObjectUtils.isEmpty((Object)delFlag)) {
            this.setFieldValByName(this.autoFillProperties.getDelFlagField(), "0", metaObject);
        }
    }

    private Long getUserId() {
        Long userId = CoreConstants.USER_ID_NULL;
        if (HussarUtils.isEmpty((Object)this.getLoginUserService)) {
            log.warn("\u672a\u6ce8\u5165mpGetUserInfoService\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\uff01");
            return userId;
        }
        UserDetails userDetails = this.getLoginUserService.getCurrentUserDetail();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            userId = userDetails.getUserId();
        }
        return userId;
    }

    private boolean pkIsNull(Object pk) {
        if (pk == null) {
            return true;
        }
        if (pk instanceof String) {
            return HussarUtils.isEmpty((Object)((String)pk));
        }
        if (pk instanceof Long) {
            long longPk = (Long)pk;
            return HussarUtils.isEmpty((Object)longPk) || longPk == 0L;
        }
        return false;
    }
}

