/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.config;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.database.adapter.BigDecimalNumericTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectBitTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectBlobTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectClobTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectDateTypeHandler;
import com.jxdinfo.hussar.support.mp.database.adapter.ObjectTimeStampTypeHandler;
import com.jxdinfo.hussar.support.mp.log.Log4j2Impl;
import com.jxdinfo.hussar.support.mp.log.NoLoggingImpl;
import com.jxdinfo.hussar.support.mp.typeconvter.JsonStringArrayTypeHandler;
import java.math.BigDecimal;
import org.apache.ibatis.logging.stdout.StdOutImpl;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class MpMybatisPropertiesCustomizer
implements ConfigurationCustomizer {
    public void customize(MybatisConfiguration configuration) {
        Class logImpl = configuration.getLogImpl();
        if (HussarUtils.isEmpty((Object)logImpl)) {
            configuration.setLogImpl(NoLoggingImpl.class);
        } else if (!HussarUtils.equals(StdOutImpl.class, (Object)logImpl)) {
            configuration.setLogImpl(Log4j2Impl.class);
        }
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (HussarUtils.isNotEmpty((Object)typeHandlerRegistry)) {
            typeHandlerRegistry.register(JsonStringArrayTypeHandler.class.getPackage().getName());
            typeHandlerRegistry.register(Object.class, JdbcType.TIMESTAMP, (TypeHandler)new ObjectTimeStampTypeHandler());
            typeHandlerRegistry.register(Object.class, JdbcType.CLOB, (TypeHandler)new ObjectClobTypeHandler());
            typeHandlerRegistry.register(Object.class, JdbcType.DATE, (TypeHandler)new ObjectDateTypeHandler());
            typeHandlerRegistry.register(Object.class, JdbcType.BLOB, (TypeHandler)new ObjectBlobTypeHandler());
            typeHandlerRegistry.register(Object.class, JdbcType.BIT, (TypeHandler)new ObjectBitTypeHandler());
            typeHandlerRegistry.register(BigDecimal.class, JdbcType.NUMERIC, (TypeHandler)new BigDecimalNumericTypeHandler());
        }
    }
}

