/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.base.query.generator;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SqlInjectionUtil;
import com.jxdinfo.hussar.support.mp.base.query.dto.FieldMappingDto;
import com.jxdinfo.hussar.support.mp.base.query.dto.QueryConditionDto;
import com.jxdinfo.hussar.support.mp.base.query.enums.MatchTypeEnum;
import com.jxdinfo.hussar.support.mp.base.query.enums.QueryRuleEnum;
import com.jxdinfo.hussar.support.mp.base.query.generator.QueryGenerator;
import com.jxdinfo.hussar.support.mp.exception.MpRuntimeException;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTableQueryGenerator
extends QueryGenerator {
    private static Logger log = LoggerFactory.getLogger(SingleTableQueryGenerator.class);
    private static List<String> filterFieldList = new ArrayList<String>();

    @Override
    protected List<FieldMappingDto> createQueryWrapper(QueryWrapper<?> queryWrapper, Object searchObj, Map<String, String[]> parameterMap) {
        PropertyDescriptor[] origDescriptors = HussarUtils.getPropertyDescriptors(searchObj.getClass());
        ArrayList<FieldMappingDto> fieldMappingDtoList = new ArrayList<FieldMappingDto>();
        for (PropertyDescriptor origDescriptor : origDescriptors) {
            String name = origDescriptor.getName();
            Class<?> type = origDescriptor.getPropertyType();
            try {
                if (this.judgedIsUselessField(name) || !PropertyUtils.isReadable((Object)searchObj, (String)name)) continue;
                Object value = PropertyUtils.getSimpleProperty((Object)searchObj, (String)name);
                String column = SingleTableQueryGenerator.getTableFieldName(searchObj.getClass(), name);
                if (HussarUtils.isBlank((CharSequence)column)) continue;
                FieldMappingDto fieldMappingDto = new FieldMappingDto(name, column, type);
                fieldMappingDtoList.add(fieldMappingDto);
                SingleTableQueryGenerator.doJoinQuery(queryWrapper, parameterMap, fieldMappingDto, value);
            }
            catch (Exception e) {
                log.error("\u5b57\u6bb5:{} \u62fc\u63a5\u67e5\u8be2\u6784\u9020\u5668\u5f02\u5e38\uff1a{}", (Object)name, (Object)e.getMessage());
                throw new MpRuntimeException(e);
            }
        }
        return fieldMappingDtoList;
    }

    private static void doJoinQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, FieldMappingDto fieldMappingDto, Object value) throws ParseException {
        if (HussarUtils.isNotEmpty((Object)value)) {
            fieldMappingDto.setFieldValue(value);
            fieldMappingDto.setRule(QueryRuleEnum.EQ);
            QueryRuleEnum.EQ.getQueryStrategy().joinQueryWrapper(queryWrapper, fieldMappingDto);
            return;
        }
        if (HussarUtils.isNotEmpty(parameterMap)) {
            for (QueryRuleEnum queryRuleEnum : QueryRuleEnum.values()) {
                String paramKey = fieldMappingDto.getFieldName().concat(queryRuleEnum.getValue());
                if (!parameterMap.containsKey(paramKey)) continue;
                String paramValue = parameterMap.get(paramKey)[0].trim();
                fieldMappingDto.setFieldValue(paramValue);
                fieldMappingDto.setRule(queryRuleEnum);
                fieldMappingDto = queryRuleEnum.getQueryStrategy().transFieldValue(fieldMappingDto);
                queryRuleEnum.getQueryStrategy().joinQueryWrapper(queryWrapper, fieldMappingDto);
            }
        }
    }

    @Override
    protected void doMultiFieldsOrder(QueryWrapper<?> queryWrapper, Object searchObj, Map<String, String[]> parameterMap) {
        String orderRule = null;
        if (HussarUtils.isNotEmpty(parameterMap) && parameterMap.containsKey("orderRule")) {
            orderRule = parameterMap.get("orderRule")[0];
        }
        if (HussarUtils.isNotEmpty(orderRule)) {
            String[] orderColumns = orderRule.split(";");
            ArrayList<String> ascColumns = new ArrayList<String>();
            ArrayList<String> descColumns = new ArrayList<String>();
            for (String rule : orderColumns) {
                if (HussarUtils.isBlank((CharSequence)rule)) continue;
                String[] order = rule.trim().split(",");
                String column = SingleTableQueryGenerator.getTableFieldName(searchObj.getClass(), order[0].trim());
                if (HussarUtils.isBlank((CharSequence)column)) continue;
                SqlInjectionUtil.filterContent((String)column);
                String orderType = order.length > 1 ? order[1].trim() : "ASC";
                log.debug("\u6392\u5e8f\u89c4\u5219>>\u5217:" + column + ",\u6392\u5e8f\u65b9\u5f0f:" + orderType);
                if ("ASC".equals(orderType.toUpperCase())) {
                    ascColumns.add(column);
                    continue;
                }
                descColumns.add(column);
            }
            if (HussarUtils.isNotEmpty(ascColumns)) {
                queryWrapper.orderByAsc(ascColumns);
            }
            if (HussarUtils.isNotEmpty(descColumns)) {
                queryWrapper.orderByDesc(descColumns);
            }
        }
    }

    @Override
    protected void doSuperQuery(QueryWrapper<?> queryWrapper, Map<String, String[]> parameterMap, List<FieldMappingDto> fieldMappingDtoList) {
        if (HussarUtils.isNotEmpty(parameterMap) && parameterMap.containsKey("superQueryParams")) {
            String superQueryParams = parameterMap.get("superQueryParams")[0];
            String superQueryMatchType = parameterMap.get("superQueryMatchType") != null ? parameterMap.get("superQueryMatchType")[0] : MatchTypeEnum.AND.getValue();
            MatchTypeEnum matchType = MatchTypeEnum.getByValue(superQueryMatchType.toUpperCase());
            try {
                superQueryParams = URLDecoder.decode(superQueryParams, "UTF-8");
                List conditions = JsonUtil.readList((String)superQueryParams, QueryConditionDto.class);
                if (HussarUtils.isEmpty((Object)conditions)) {
                    return;
                }
                log.info("---\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570-->" + conditions.toString());
                queryWrapper.and(andWrapper -> {
                    for (int i = 0; i < conditions.size(); ++i) {
                        QueryConditionDto rule = (QueryConditionDto)conditions.get(i);
                        if (!HussarUtils.isNotEmpty((Object)rule.getField()) || !HussarUtils.isNotEmpty((Object)rule.getRule()) || !HussarUtils.isNotEmpty((Object)rule.getVal())) continue;
                        log.debug("SuperQuery ==> " + rule.toString());
                        Object queryValue = rule.getVal();
                        if ("date".equals(rule.getType())) {
                            queryValue = HussarUtils.parseDate((String)rule.getVal(), (String)"yyyy-MM-dd");
                        } else if ("dateTime".equals(rule.getType())) {
                            queryValue = HussarUtils.parseDate((String)rule.getVal(), (String)"yyyy-MM-dd HH:mm:ss");
                        }
                        FieldMappingDto fieldMappingDto = SingleTableQueryGenerator.findListByField(fieldMappingDtoList, rule.getField());
                        fieldMappingDto.setFieldValue(queryValue);
                        fieldMappingDto.setRule(QueryRuleEnum.getByValue(rule.getRule()));
                        fieldMappingDto.getRule().getQueryStrategy().joinQueryWrapper((QueryWrapper<?>)andWrapper, fieldMappingDto);
                        if (!MatchTypeEnum.OR.equals((Object)matchType) || i >= conditions.size() - 1) continue;
                        andWrapper.or();
                    }
                });
            }
            catch (UnsupportedEncodingException e) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u53c2\u6570\u8f6c\u7801\u5931\u8d25\uff1a" + superQueryParams, (Throwable)e);
            }
            catch (Exception e) {
                log.error("--\u9ad8\u7ea7\u67e5\u8be2\u62fc\u63a5\u5931\u8d25\uff1a" + e.getMessage());
                throw new MpRuntimeException(e);
            }
        }
        log.info(" superQuery getCustomSqlSegment: " + queryWrapper.getCustomSqlSegment());
    }

    private static FieldMappingDto findListByField(List<FieldMappingDto> fieldMappingDtoList, String feildName) {
        return fieldMappingDtoList.stream().filter(fieldMappingDto -> fieldMappingDto.getFieldName().equalsIgnoreCase(feildName)).findFirst().orElse(null);
    }

    @Override
    protected boolean judgedIsUselessField(String fieldName) {
        return filterFieldList.contains(fieldName);
    }

    private static String getTableFieldName(Class<?> clazz, String name) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(clazz);
        if (name.equals(tableInfo.getKeyProperty())) {
            return tableInfo.getKeyColumn();
        }
        List tableFieldInfos = tableInfo.getFieldList();
        TableFieldInfo field = null;
        if (HussarUtils.isNotEmpty((Object)tableFieldInfos)) {
            List searchFields = tableFieldInfos.stream().filter(a -> a.getProperty().equals(name)).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(searchFields)) {
                field = (TableFieldInfo)searchFields.get(0);
            }
            if (HussarUtils.isNotEmpty(field)) {
                return field.getColumn();
            }
        }
        return null;
    }

    static {
        filterFieldList.add("class");
        filterFieldList.add("ids");
        filterFieldList.add("page");
        filterFieldList.add("rows");
        filterFieldList.add("sort");
        filterFieldList.add("order");
    }
}

