/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.transaction;

import com.jxdinfo.hussar.platform.core.support.sign.HussarDynamicDatasourceSign;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.transaction.Transaction;
import org.mybatis.logging.Logger;
import org.mybatis.logging.LoggerFactory;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class HussarMpTransactionManager
implements Transaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarMpTransactionManager.class);
    private final DataSource dataSource;
    private Connection connection;
    private DataSource targetDatasouce;
    private boolean isConnectionTransactional;
    private boolean autoCommit;

    public HussarMpTransactionManager(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"No DataSource specified");
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.openConnection();
        }
        return this.connection;
    }

    private void openConnection() throws SQLException {
        this.targetDatasouce = this.getDataSource();
        this.connection = DataSourceUtils.getConnection((DataSource)this.targetDatasouce);
        this.autoCommit = this.connection.getAutoCommit();
        this.isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)this.connection, (DataSource)this.targetDatasouce);
        LOGGER.debug(() -> "JDBC Connection [" + this.connection + "] will" + (this.isConnectionTransactional ? " " : " not ") + "be managed by Spring");
    }

    private DataSource getDataSource() {
        if (this.dataSource instanceof HussarDynamicDatasourceSign) {
            HussarDynamicDatasourceSign dynamicDatasourceSign = (HussarDynamicDatasourceSign)this.dataSource;
            return dynamicDatasourceSign.getTransactionDatasource();
        }
        return this.dataSource;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
            LOGGER.debug(() -> "Committing JDBC Connection [" + this.connection + "]");
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
            LOGGER.debug(() -> "Rolling back JDBC Connection [" + this.connection + "]");
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        DataSourceUtils.releaseConnection((Connection)this.connection, (DataSource)this.targetDatasouce);
    }

    public Integer getTimeout() throws SQLException {
        ConnectionHolder holder = (ConnectionHolder)TransactionSynchronizationManager.getResource((Object)this.targetDatasouce);
        if (holder != null && holder.hasTimeout()) {
            return holder.getTimeToLiveInSeconds();
        }
        return null;
    }
}

