/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.plugin.sensitive.interceptor;

import com.jxdinfo.hussar.platform.core.annotation.Sensitive;
import com.jxdinfo.hussar.platform.core.enums.SensitiveStrategy;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSensitiveInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractSensitiveInterceptor.class);

    protected void sensitive(Object source) {
        if (HussarUtils.isEmpty((Object)source)) {
            return;
        }
        Class<?> sourceClass = source.getClass();
        MetaObject metaObject = SystemMetaObject.forObject((Object)source);
        Stream.of(sourceClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Sensitive.class)).forEach(field -> this.doSensitive(metaObject, (Field)field));
    }

    private void doSensitive(MetaObject metaObject, Field field) {
        if (this.vailidSensitive(metaObject, field)) {
            Function<String, String> desensitizer;
            String name = field.getName();
            Object value = metaObject.getValue(name);
            Sensitive annotation = field.getAnnotation(Sensitive.class);
            if (HussarUtils.isNotEmpty((Object)annotation.regex()) && HussarUtils.isNotEmpty((Object)annotation.replace())) {
                desensitizer = s -> s.replaceAll(annotation.regex(), annotation.replace());
            } else {
                SensitiveStrategy type = annotation.strategy();
                desensitizer = type.getDesensitizer();
            }
            try {
                String o = desensitizer.apply((String)value);
                metaObject.setValue(name, (Object)o);
            }
            catch (PatternSyntaxException e) {
                log.debug("\u8131\u654f\u5904\u7406\u5931\u8d25:{}\uff0c\u914d\u7f6e\u89c4\u5219{}", value, desensitizer);
            }
        }
    }

    private boolean vaildFieldType(MetaObject metaObject, String fieldName) {
        Class getterType = metaObject.getGetterType(fieldName);
        return String.class.isAssignableFrom(getterType);
    }

    private boolean vailidSensitive(MetaObject metaObject, Field field) {
        if (HussarUtils.isEmpty((Object)metaObject) || HussarUtils.isEmpty((Object)field)) {
            return false;
        }
        String name = field.getName();
        Object value = metaObject.getValue(name);
        if (HussarUtils.isEmpty((Object)value)) {
            return false;
        }
        Sensitive annotation = field.getAnnotation(Sensitive.class);
        if (HussarUtils.isEmpty((Object)annotation) || HussarUtils.isEmpty((Object)name)) {
            return false;
        }
        boolean onlyAudit = annotation.onlyAudit();
        boolean fieldType = this.vaildFieldType(metaObject, name);
        return !onlyAudit && fieldType;
    }
}

