/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.plugin.sensitive.interceptor;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.annotation.Sensitive;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.plugin.sensitive.config.SensitiveProperties;
import com.jxdinfo.hussar.support.mp.plugin.sensitive.interceptor.AbstractSensitiveInterceptor;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class SensitiveInterceptor
extends AbstractSensitiveInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SensitiveInterceptor.class);
    private static final String MAPPED_STATEMENT = "mappedStatement";
    private Properties properties;
    private final SensitiveProperties sensitiveProperties;

    public SensitiveInterceptor(SensitiveProperties sensitiveProperties) {
        this.sensitiveProperties = sensitiveProperties;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        List records = (List)invocation.proceed();
        ResultSetHandler resultSetHandler = (ResultSetHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)resultSetHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPED_STATEMENT);
        ResultMap resultMap = mappedStatement.getResultMaps().isEmpty() ? null : (ResultMap)mappedStatement.getResultMaps().get(0);
        Class sourceClass = resultMap.getType();
        List collect = Stream.of(sourceClass.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Sensitive.class)).collect(Collectors.toList());
        if (HussarUtils.isEmpty(collect)) {
            return records;
        }
        records.forEach(this::sensitive);
        return records;
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

