/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.mp.plugin.sensitive.interceptor;

import com.jxdinfo.hussar.support.mp.plugin.sensitive.config.SensitiveProperties;
import com.jxdinfo.hussar.support.mp.plugin.sensitive.interceptor.AbstractSensitiveInterceptor;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class SensitiveInterceptor
extends AbstractSensitiveInterceptor {
    private static Logger log = LoggerFactory.getLogger(SensitiveInterceptor.class);
    private Properties properties;
    private SensitiveProperties sensitiveProperties;

    public SensitiveInterceptor(SensitiveProperties sensitiveProperties) {
        this.sensitiveProperties = sensitiveProperties;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        List records = (List)invocation.proceed();
        records.forEach(this::sensitive);
        return records;
    }

    public Object plugin(Object target) {
        if (target instanceof ResultSetHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

