/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.lock.redis.algorithm;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarRedisLockAlgorithm;
import com.jxdinfo.hussar.support.lock.redis.config.HussarRedisLockProperties;
import com.jxdinfo.hussar.support.lock.redis.constant.HussarRedisLockConstants;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.UncheckedInterruptedException;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class HussarRedissonReentrantLockAlgorithm
implements HussarRedisLockAlgorithm<RLock> {
    private final RedissonClient redisson;
    private final HussarRedisLockProperties properties;

    public HussarRedissonReentrantLockAlgorithm(RedissonClient redisson, HussarRedisLockProperties properties) {
        this.redisson = redisson;
        this.properties = properties;
    }

    @Override
    public String getAlgorithmName() {
        return "REDISSON_REENTRANT_LOCK";
    }

    @Override
    public RLock acquire(String key, Duration timeout) {
        return this.acquire(key, timeout, null);
    }

    @Override
    public RLock acquire(String key, Duration waitTimeout, Duration expireTimeout) {
        RLock lock = this.getLock(key);
        Duration lockExpire = this.getLockExpire();
        if (HussarUtils.isNotEmpty((Object)expireTimeout)) {
            lockExpire = expireTimeout;
        }
        try {
            boolean locked = lock.tryLock(waitTimeout.toMillis(), lockExpire.toMillis(), TimeUnit.MILLISECONDS);
            return locked ? lock : null;
        }
        catch (InterruptedException ex) {
            throw new UncheckedInterruptedException((Throwable)ex);
        }
    }

    @Override
    public RLock tryAcquire(String key) {
        RLock lock = this.getLock(key);
        boolean locked = lock.tryLock();
        return locked ? lock : null;
    }

    @Override
    public boolean release(String key, RLock state) {
        if (state.isHeldByCurrentThread()) {
            state.unlock();
            return true;
        }
        return false;
    }

    private RLock getLock(String key) {
        String scopedKey = "lock:" + key;
        return this.redisson.getLock(scopedKey);
    }

    private Duration getLockExpire() {
        Duration lockExpire = this.properties.getLockExpire();
        if (lockExpire == null || lockExpire.compareTo(Duration.ZERO) <= 0) {
            lockExpire = HussarRedisLockConstants.DEFAULT_LOCK_EXPIRE;
        }
        return lockExpire;
    }
}

